/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.utils;

import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.FastPathResolver;
import io.github.classgraph.utils.FileUtils;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.VersionFinder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarfileMetadataReader {
    public boolean isSystemJar;
    public List<ZipEntry> zipEntries;
    public List<String> classPathEntriesToScan;
    public String mainPackageRootPrefix;
    public List<String> additionalPackageRootPrefixes;
    private List<String> libJarPaths;
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String MULTI_RELEASE_PATH_PREFIX = "META-INF/versions/";

    private void addClassPathEntryToScan(String classPathEntryPath) {
        if (this.classPathEntriesToScan == null) {
            this.classPathEntriesToScan = new ArrayList<String>();
        }
        this.classPathEntriesToScan.add(classPathEntryPath);
    }

    private void addSpaceDelimitedClassPathToScan(String zipFilePath, String classPath) {
        for (String classpathEntry : classPath.split(" ")) {
            if (classpathEntry.isEmpty()) continue;
            this.addClassPathEntryToScan(zipFilePath == null ? classpathEntry : zipFilePath + "!" + classpathEntry);
        }
    }

    private void addLibJarEntry(String libJarPath) {
        if (this.libJarPaths == null) {
            this.libJarPaths = new ArrayList<String>();
        }
        this.libJarPaths.add(libJarPath);
    }

    private String extractManifestField(String manifest, int classPathIdx) {
        int len = manifest.length();
        StringBuilder buf = new StringBuilder();
        int curr = classPathIdx;
        if (curr < len && manifest.charAt(curr) == ' ') {
            ++curr;
        }
        while (curr < len) {
            char c = manifest.charAt(curr);
            if (c == '\r' && (curr < len - 1 ? (int)manifest.charAt(curr + 1) : 10) == 10) {
                if ((curr < len - 2 ? (int)manifest.charAt(curr + 2) : 10) != 32) break;
                curr += 2;
            } else if (c == '\r') {
                if ((curr < len - 1 ? (int)manifest.charAt(curr + 1) : 10) != 32) break;
                ++curr;
            } else if (c == '\n') {
                if ((curr < len - 1 ? (int)manifest.charAt(curr + 1) : 10) != 32) break;
                ++curr;
            } else {
                buf.append(c);
            }
            ++curr;
        }
        return buf.toString().trim();
    }

    JarfileMetadataReader(File jarFile, ScanSpec scanSpec, LogNode log) {
        block51: {
            this.mainPackageRootPrefix = "";
            try (ZipFile zipFile = new ZipFile(jarFile);){
                int numEntries = zipFile.size();
                ArrayList<ZipEntry> rawZipEntries = new ArrayList<ZipEntry>(numEntries);
                String jarFileName = FastPathResolver.resolve(jarFile.getPath());
                int highestScannableVersion = 8;
                Enumeration<? extends ZipEntry> iter = zipFile.entries();
                while (iter.hasMoreElements()) {
                    ZipEntry zipEntry = iter.nextElement();
                    if (zipEntry.isDirectory()) continue;
                    rawZipEntries.add(zipEntry);
                    Object zipEntryPath = zipEntry.getName();
                    if (((String)zipEntryPath).endsWith("/")) {
                        zipEntryPath = ((String)zipEntryPath).substring(0, ((String)zipEntryPath).length() - 1);
                    }
                    if (((String)zipEntryPath).startsWith("/")) {
                        zipEntryPath = ((String)zipEntryPath).substring(1);
                    }
                    if (!((String)zipEntryPath).startsWith(MULTI_RELEASE_PATH_PREFIX) || ((String)zipEntryPath).length() <= MULTI_RELEASE_PATH_PREFIX.length() + 1) continue;
                    int nextSlashIdx = ((String)zipEntryPath).indexOf(47, MULTI_RELEASE_PATH_PREFIX.length());
                    String versionStr = ((String)zipEntryPath).substring(MULTI_RELEASE_PATH_PREFIX.length(), nextSlashIdx < 0 ? ((String)zipEntryPath).length() : nextSlashIdx);
                    try {
                        int versionInt = Integer.parseInt(versionStr);
                        if (versionInt > VersionFinder.JAVA_MAJOR_VERSION || versionInt <= highestScannableVersion) continue;
                        highestScannableVersion = versionInt;
                    }
                    catch (NumberFormatException versionInt) {}
                }
                if (highestScannableVersion >= 9) {
                    String versionRoot = MULTI_RELEASE_PATH_PREFIX + highestScannableVersion;
                    if (log != null) {
                        log.log("Found multi-release version jar -- switching package root to: " + versionRoot);
                    }
                    this.mainPackageRootPrefix = versionRoot + "/";
                }
                ZipEntry manifestZipEntry = null;
                String versionManifestZipEntryPath = this.mainPackageRootPrefix + MANIFEST_PATH;
                for (ZipEntry zipEntry : rawZipEntries) {
                    String zipEntryPath = zipEntry.getName();
                    if (zipEntryPath.startsWith("/")) {
                        zipEntryPath = zipEntryPath.substring(1);
                    }
                    if (zipEntryPath.equals(versionManifestZipEntryPath)) {
                        manifestZipEntry = zipEntry;
                        continue;
                    }
                    if (!zipEntryPath.equals(MANIFEST_PATH)) continue;
                    manifestZipEntry = zipEntry;
                }
                String webInfClassesPrefix = this.mainPackageRootPrefix + "WEB-INF/classes/";
                String webInfLibPrefix = this.mainPackageRootPrefix + "WEB-INF/lib/";
                String webInfLibProvidedPrefix = this.mainPackageRootPrefix + "WEB-INF/lib-provided/";
                String libPrefix = this.mainPackageRootPrefix + "lib/";
                String springBootLibPrefix = this.mainPackageRootPrefix + "BOOT-INF/lib";
                String springBootClassesPrefix = this.mainPackageRootPrefix + "BOOT-INF/classes";
                if (manifestZipEntry != null) {
                    try (InputStream inputStream = zipFile.getInputStream(manifestZipEntry);){
                        int springBootLibIdx;
                        int springBootClassesIdx;
                        String manifest = FileUtils.readAllBytesAsString(inputStream, manifestZipEntry.getSize(), log);
                        this.isSystemJar = manifest.indexOf("\nImplementation-Title: Java Runtime Environment") > 0 || manifest.indexOf("\nSpecification-Title: Java Platform API Specification") > 0;
                        int classPathIdx = manifest.indexOf("\nClass-Path:");
                        if (classPathIdx >= 0) {
                            String classPathField = this.extractManifestField(manifest, classPathIdx + 12);
                            this.addSpaceDelimitedClassPathToScan(null, classPathField);
                            if (log != null) {
                                log.log("Found Class-Path entry in manifest file: " + classPathField);
                            }
                        }
                        if ((springBootClassesIdx = manifest.indexOf("\nSpring-Boot-Classes:")) >= 0) {
                            springBootClassesPrefix = this.mainPackageRootPrefix + this.extractManifestField(manifest, springBootClassesIdx + 21);
                            if (springBootClassesPrefix.startsWith("/")) {
                                springBootClassesPrefix = springBootClassesPrefix.substring(1);
                            }
                            if (!springBootClassesPrefix.isEmpty() && !springBootClassesPrefix.endsWith("/")) {
                                springBootClassesPrefix = springBootClassesPrefix + '/';
                            }
                        }
                        if ((springBootLibIdx = manifest.indexOf("\nSpring-Boot-Lib:")) >= 0) {
                            springBootLibPrefix = this.mainPackageRootPrefix + this.extractManifestField(manifest, springBootLibIdx + 17);
                            if (springBootLibPrefix.startsWith("/")) {
                                springBootLibPrefix = springBootLibPrefix.substring(1);
                            }
                            if (!springBootLibPrefix.isEmpty() && !springBootLibPrefix.endsWith("/")) {
                                springBootLibPrefix = springBootLibPrefix + '/';
                            }
                        }
                    }
                }
                if (!this.mainPackageRootPrefix.isEmpty()) {
                    this.zipEntries = new ArrayList<ZipEntry>(rawZipEntries.size());
                    for (ZipEntry zipEntry : rawZipEntries) {
                        if (!zipEntry.getName().startsWith(this.mainPackageRootPrefix)) continue;
                        this.zipEntries.add(zipEntry);
                    }
                } else {
                    this.zipEntries = new ArrayList<ZipEntry>(rawZipEntries);
                }
                String bootInfZipEntryPathPrefix = null;
                String webInfZipEntryPathPrefix = null;
                for (int i = 0; i < this.zipEntries.size(); ++i) {
                    ZipEntry zipEntry = this.zipEntries.get(i);
                    String zipEntryPath = zipEntry.getName();
                    if (zipEntryPath.endsWith("/")) {
                        zipEntryPath = zipEntryPath.substring(0, zipEntryPath.length() - 1);
                    }
                    if (zipEntryPath.startsWith("/")) {
                        zipEntryPath = zipEntryPath.substring(1);
                    }
                    if (bootInfZipEntryPathPrefix == null && zipEntryPath.startsWith(springBootClassesPrefix)) {
                        if (log != null) {
                            log.log("Found Spring-Boot package root: " + springBootClassesPrefix);
                        }
                        bootInfZipEntryPathPrefix = springBootClassesPrefix;
                    }
                    if (webInfZipEntryPathPrefix == null && zipEntryPath.startsWith(webInfClassesPrefix)) {
                        if (log != null) {
                            log.log("Found WAR class root: " + webInfClassesPrefix);
                        }
                        webInfZipEntryPathPrefix = webInfClassesPrefix;
                    }
                    if (!zipEntryPath.startsWith(springBootLibPrefix) && !zipEntryPath.startsWith(webInfLibPrefix) && !zipEntryPath.startsWith(webInfLibProvidedPrefix) && !zipEntryPath.startsWith(libPrefix) || !zipEntryPath.endsWith(".jar")) continue;
                    if (scanSpec.scanNestedJars) {
                        if (log != null) {
                            log.log("Found lib jar: " + zipEntryPath);
                        }
                        String libJarPath = jarFileName + "!" + zipEntryPath;
                        this.addClassPathEntryToScan(libJarPath);
                        this.addLibJarEntry(libJarPath);
                        continue;
                    }
                    if (log == null) continue;
                    log.log("Skipping lib jar because nested jar scanning is disabled: " + zipEntryPath);
                }
                if (bootInfZipEntryPathPrefix != null && !bootInfZipEntryPathPrefix.isEmpty()) {
                    this.mainPackageRootPrefix = bootInfZipEntryPathPrefix;
                    if (log != null) {
                        log.log("Adding \"\" as a package root, so that Spring Boot classes will be scanned");
                    }
                    if (this.additionalPackageRootPrefixes == null) {
                        this.additionalPackageRootPrefixes = new ArrayList<String>();
                    }
                    this.additionalPackageRootPrefixes.add("");
                    if (webInfZipEntryPathPrefix != null) {
                        this.addClassPathEntryToScan(jarFileName + "!" + (webInfClassesPrefix.endsWith("/") ? webInfClassesPrefix.substring(0, webInfClassesPrefix.length() - 1) : webInfClassesPrefix));
                    }
                } else if (webInfZipEntryPathPrefix != null) {
                    this.mainPackageRootPrefix = webInfZipEntryPathPrefix;
                }
            }
            catch (IOException e) {
                this.zipEntries = Collections.emptyList();
                if (log == null) break block51;
                log.log("Exception while opening jarfile " + jarFile, e);
            }
        }
    }
}

