/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.discovery;

import com.esotericsoftware.kryo.Serializer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AtomicLongMap;
import io.atomix.cluster.BootstrapService;
import io.atomix.cluster.Node;
import io.atomix.cluster.NodeId;
import io.atomix.cluster.discovery.MulticastDiscoveryBuilder;
import io.atomix.cluster.discovery.MulticastDiscoveryConfig;
import io.atomix.cluster.discovery.NodeDiscoveryEvent;
import io.atomix.cluster.discovery.NodeDiscoveryEventListener;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.cluster.impl.AddressSerializer;
import io.atomix.utils.concurrent.Threads;
import io.atomix.utils.event.AbstractListenerManager;
import io.atomix.utils.event.Event;
import io.atomix.utils.net.Address;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastDiscoveryProvider
extends AbstractListenerManager<NodeDiscoveryEvent, NodeDiscoveryEventListener>
implements NodeDiscoveryProvider {
    public static final Type TYPE = new Type();
    private static final Logger LOGGER = LoggerFactory.getLogger(MulticastDiscoveryProvider.class);
    private static final io.atomix.utils.serializer.Serializer SERIALIZER = io.atomix.utils.serializer.Serializer.builder().addType(Node.class).addType(NodeId.class).addSerializer((Serializer)new AddressSerializer(), new Class[]{Address.class}).build();
    private static final String DISCOVERY_SUBJECT = "atomix-discovery";
    private final MulticastDiscoveryConfig config;
    private volatile BootstrapService bootstrap;
    private final ScheduledExecutorService broadcastScheduler = Executors.newSingleThreadScheduledExecutor(Threads.namedThreads((String)"atomix-cluster-broadcast", (Logger)LOGGER));
    private volatile ScheduledFuture<?> broadcastFuture;
    private final Consumer<byte[]> broadcastListener = message -> this.broadcastScheduler.execute(() -> this.handleBroadcastMessage((byte[])message));
    private final Map<NodeId, Node> nodes = Maps.newConcurrentMap();
    private final AtomicLongMap<NodeId> updateTimes = AtomicLongMap.create();

    public static MulticastDiscoveryBuilder builder() {
        return new MulticastDiscoveryBuilder();
    }

    public MulticastDiscoveryProvider() {
        this(new MulticastDiscoveryConfig());
    }

    public MulticastDiscoveryProvider(MulticastDiscoveryConfig config) {
        this.config = (MulticastDiscoveryConfig)Preconditions.checkNotNull((Object)config);
    }

    public MulticastDiscoveryConfig config() {
        return this.config;
    }

    @Override
    public Set<Node> getNodes() {
        return ImmutableSet.copyOf(this.nodes.values());
    }

    private void handleBroadcastMessage(byte[] message) {
        Node node = (Node)SERIALIZER.decode(message);
        Node oldNode = this.nodes.put(node.id(), node);
        if (oldNode != null && !oldNode.id().equals(node.id())) {
            this.post((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.LEAVE, oldNode));
            this.post((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.JOIN, node));
        } else if (oldNode == null) {
            this.post((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.JOIN, node));
        }
        this.updateTimes.put((Object)node.id(), System.currentTimeMillis());
    }

    private void broadcastNode(Node localNode) {
        this.bootstrap.getBroadcastService().broadcast(DISCOVERY_SUBJECT, SERIALIZER.encode((Object)localNode));
        this.expireNodes();
    }

    private void expireNodes() {
        Iterator<Map.Entry<NodeId, Node>> iterator = this.nodes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<NodeId, Node> entry = iterator.next();
            if (System.currentTimeMillis() - this.updateTimes.get((Object)entry.getKey()) <= this.config.getFailureTimeout().toMillis()) continue;
            iterator.remove();
            this.post((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.LEAVE, entry.getValue()));
        }
    }

    @Override
    public CompletableFuture<Void> join(BootstrapService bootstrap, Node localNode) {
        if (this.nodes.putIfAbsent(localNode.id(), localNode) == null) {
            this.bootstrap = bootstrap;
            this.post((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.JOIN, localNode));
            bootstrap.getBroadcastService().addListener(DISCOVERY_SUBJECT, this.broadcastListener);
            this.broadcastFuture = this.broadcastScheduler.scheduleAtFixedRate(() -> this.broadcastNode(localNode), this.config.getBroadcastInterval().toMillis(), this.config.getBroadcastInterval().toMillis(), TimeUnit.MILLISECONDS);
            this.broadcastNode(localNode);
            LOGGER.info("Joined");
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> leave(Node localNode) {
        if (this.nodes.remove(localNode.id()) != null) {
            this.post((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.LEAVE, localNode));
            this.bootstrap.getBroadcastService().removeListener(DISCOVERY_SUBJECT, this.broadcastListener);
            ScheduledFuture<?> broadcastFuture = this.broadcastFuture;
            if (broadcastFuture != null) {
                broadcastFuture.cancel(false);
            }
            LOGGER.info("Left");
        }
        return CompletableFuture.completedFuture(null);
    }

    public static class Type
    implements NodeDiscoveryProvider.Type<MulticastDiscoveryConfig> {
        private static final String NAME = "multicast";

        public String name() {
            return NAME;
        }

        public MulticastDiscoveryConfig newConfig() {
            return new MulticastDiscoveryConfig();
        }

        @Override
        public NodeDiscoveryProvider newProvider(MulticastDiscoveryConfig config) {
            return new MulticastDiscoveryProvider(config);
        }
    }
}

