/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import com.google.common.base.MoreObjects;
import io.atomix.cluster.messaging.impl.ProtocolMessage;
import io.atomix.utils.misc.ArraySizeHashPrinter;

public final class ProtocolReply
extends ProtocolMessage {
    private final Status status;

    public ProtocolReply(long id, byte[] payload, Status status) {
        super(id, payload);
        this.status = status;
    }

    @Override
    public ProtocolMessage.Type type() {
        return ProtocolMessage.Type.REPLY;
    }

    public Status status() {
        return this.status;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id()).add("status", (Object)this.status()).add("payload", (Object)ArraySizeHashPrinter.of((byte[])this.payload())).toString();
    }

    public static enum Status {
        OK(0),
        ERROR_NO_HANDLER(1),
        ERROR_HANDLER_EXCEPTION(2),
        PROTOCOL_EXCEPTION(3);

        private final int id;

        private Status(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public static Status forId(int id) {
            switch (id) {
                case 0: {
                    return OK;
                }
                case 1: {
                    return ERROR_NO_HANDLER;
                }
                case 2: {
                    return ERROR_HANDLER_EXCEPTION;
                }
                case 3: {
                    return PROTOCOL_EXCEPTION;
                }
            }
            throw new IllegalArgumentException("Unknown status ID " + id);
        }
    }
}

