/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.collection.impl;

import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.collection.CollectionEventListener;
import io.atomix.core.collection.DistributedCollection;
import io.atomix.core.collection.DistributedCollectionType;
import io.atomix.core.collection.impl.BlockingDistributedCollection;
import io.atomix.core.iterator.AsyncIterator;
import io.atomix.core.iterator.impl.AsyncJavaIterator;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class AsyncDistributedJavaCollection<E>
implements AsyncDistributedCollection<E> {
    private final String name;
    private final PrimitiveProtocol protocol;
    private final Collection<E> collection;

    public AsyncDistributedJavaCollection(String name, PrimitiveProtocol protocol, Collection<E> collection) {
        this.name = name;
        this.protocol = protocol;
        this.collection = collection;
    }

    public String name() {
        return this.name;
    }

    public PrimitiveType type() {
        return DistributedCollectionType.instance();
    }

    public PrimitiveProtocol protocol() {
        return this.protocol;
    }

    @Override
    public CompletableFuture<Boolean> add(E element) {
        return CompletableFuture.completedFuture(this.collection.add(element));
    }

    @Override
    public CompletableFuture<Boolean> remove(E element) {
        return CompletableFuture.completedFuture(this.collection.remove(element));
    }

    @Override
    public CompletableFuture<Integer> size() {
        return CompletableFuture.completedFuture(this.collection.size());
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return CompletableFuture.completedFuture(this.collection.isEmpty());
    }

    @Override
    public CompletableFuture<Void> clear() {
        this.collection.clear();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Boolean> contains(E element) {
        return CompletableFuture.completedFuture(this.collection.contains(element));
    }

    @Override
    public CompletableFuture<Boolean> addAll(Collection<? extends E> c) {
        return CompletableFuture.completedFuture(this.collection.addAll(c));
    }

    @Override
    public CompletableFuture<Boolean> containsAll(Collection<? extends E> c) {
        return CompletableFuture.completedFuture(this.collection.containsAll(c));
    }

    @Override
    public CompletableFuture<Boolean> retainAll(Collection<? extends E> c) {
        return CompletableFuture.completedFuture(this.collection.retainAll(c));
    }

    @Override
    public CompletableFuture<Boolean> removeAll(Collection<? extends E> c) {
        return CompletableFuture.completedFuture(this.collection.removeAll(c));
    }

    @Override
    public CompletableFuture<Void> addListener(CollectionEventListener<E> listener, Executor executor) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeListener(CollectionEventListener<E> listener) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public AsyncIterator<E> iterator() {
        return new AsyncJavaIterator<E>(this.collection.iterator());
    }

    public CompletableFuture<Void> close() {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> delete() {
        this.collection.clear();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public DistributedCollection<E> sync(Duration operationTimeout) {
        return new BlockingDistributedCollection(this, operationTimeout.toMillis());
    }
}

