/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.lock.impl;

import com.google.common.base.Throwables;
import io.atomix.core.lock.AsyncAtomicLock;
import io.atomix.core.lock.AtomicLock;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.Synchronous;
import io.atomix.utils.time.Version;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BlockingAtomicLock
extends Synchronous<AsyncAtomicLock>
implements AtomicLock {
    private final AsyncAtomicLock asyncLock;
    private final long operationTimeoutMillis;

    public BlockingAtomicLock(AsyncAtomicLock asyncLock, long operationTimeoutMillis) {
        super((AsyncPrimitive)asyncLock);
        this.asyncLock = asyncLock;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public Version lock() {
        return this.asyncLock.lock().join();
    }

    @Override
    public Optional<Version> tryLock() {
        return this.asyncLock.tryLock().join();
    }

    @Override
    public Optional<Version> tryLock(Duration timeout) {
        return this.asyncLock.tryLock(timeout).join();
    }

    @Override
    public boolean isLocked() {
        return this.complete(this.asyncLock.isLocked());
    }

    @Override
    public boolean isLocked(Version version) {
        return this.complete(this.asyncLock.isLocked(version));
    }

    @Override
    public void unlock() {
        this.complete(this.asyncLock.unlock());
    }

    @Override
    public AsyncAtomicLock async() {
        return this.asyncLock;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            Throwable cause = Throwables.getRootCause((Throwable)e);
            if (cause instanceof PrimitiveException) {
                throw (PrimitiveException)cause;
            }
            throw new PrimitiveException(cause);
        }
    }
}

