/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map;

import com.google.common.collect.Lists;
import io.atomix.core.cache.CachedPrimitiveBuilder;
import io.atomix.core.map.MapConfig;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.SyncPrimitive;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.NamespaceConfig;
import io.atomix.utils.serializer.Serializer;
import io.atomix.utils.serializer.SerializerBuilder;

public abstract class MapBuilder<B extends MapBuilder<B, C, P, K, V>, C extends MapConfig<C>, P extends SyncPrimitive, K, V>
extends CachedPrimitiveBuilder<B, C, P> {
    protected MapBuilder(PrimitiveType type, String name, C config, PrimitiveManagementService managementService) {
        super(type, name, config, managementService);
    }

    public B withKeyType(Class<?> keyType) {
        ((MapConfig)this.config).setKeyType(keyType);
        return (B)((Object)this);
    }

    public B withValueType(Class<?> valueType) {
        ((MapConfig)this.config).setValueType(valueType);
        return (B)((Object)this);
    }

    public B withExtraTypes(Class<?> ... extraTypes) {
        ((MapConfig)this.config).setExtraTypes(Lists.newArrayList((Object[])extraTypes));
        return (B)((Object)this);
    }

    public B addExtraType(Class<?> extraType) {
        ((MapConfig)this.config).addExtraType(extraType);
        return (B)((Object)this);
    }

    public B withRegistrationRequired() {
        return this.withRegistrationRequired(true);
    }

    public B withRegistrationRequired(boolean registrationRequired) {
        ((MapConfig)this.config).setRegistrationRequired(registrationRequired);
        return (B)((Object)this);
    }

    public B withCompatibleSerialization() {
        return this.withCompatibleSerialization(true);
    }

    public B withCompatibleSerialization(boolean compatibleSerialization) {
        ((MapConfig)this.config).setCompatibleSerialization(compatibleSerialization);
        return (B)((Object)this);
    }

    protected Serializer serializer() {
        if (this.serializer == null) {
            NamespaceConfig namespaceConfig = ((MapConfig)this.config).getNamespaceConfig();
            if (namespaceConfig == null) {
                namespaceConfig = new NamespaceConfig();
            }
            SerializerBuilder serializerBuilder = this.managementService.getSerializationService().newBuilder(this.name);
            serializerBuilder.withNamespace(new Namespace(namespaceConfig));
            if (((MapConfig)this.config).isRegistrationRequired()) {
                serializerBuilder.withRegistrationRequired();
            }
            if (((MapConfig)this.config).isCompatibleSerialization()) {
                serializerBuilder.withCompatibleSerialization();
            }
            if (((MapConfig)this.config).getKeyType() != null) {
                serializerBuilder.addType(((MapConfig)this.config).getKeyType());
            }
            if (((MapConfig)this.config).getValueType() != null) {
                serializerBuilder.addType(((MapConfig)this.config).getValueType());
            }
            if (!((MapConfig)this.config).getExtraTypes().isEmpty()) {
                serializerBuilder.withTypes(((MapConfig)this.config).getExtraTypes().toArray(new Class[((MapConfig)this.config).getExtraTypes().size()]));
            }
            this.serializer = serializerBuilder.build();
        }
        return this.serializer;
    }
}

