/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.core.iterator.impl.IteratorBatch;
import io.atomix.core.map.AtomicMapEvent;
import io.atomix.core.map.impl.AtomicMapClient;
import io.atomix.core.map.impl.AtomicMapService;
import io.atomix.core.map.impl.MapEntryUpdateResult;
import io.atomix.core.map.impl.MapUpdate;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionLog;
import io.atomix.core.transaction.impl.CommitResult;
import io.atomix.core.transaction.impl.PrepareResult;
import io.atomix.core.transaction.impl.RollbackResult;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractAtomicMapService<K>
extends AbstractPrimitiveService<AtomicMapClient>
implements AtomicMapService<K> {
    private static final int MAX_ITERATOR_BATCH_SIZE = 32768;
    private final Serializer serializer;
    protected Set<SessionId> listeners = Sets.newLinkedHashSet();
    private Map<K, MapEntryValue> map;
    protected Set<K> preparedKeys = Sets.newHashSet();
    protected Map<TransactionId, TransactionScope<K>> activeTransactions = Maps.newHashMap();
    protected Map<Long, IteratorContext> entryIterators = Maps.newHashMap();
    protected long currentVersion;

    public AbstractAtomicMapService(PrimitiveType primitiveType) {
        super(primitiveType, AtomicMapClient.class);
        this.serializer = Serializer.using((Namespace)Namespace.builder().register(primitiveType.namespace()).register(new Class[]{SessionId.class}).register(new Class[]{TransactionId.class}).register(new Class[]{TransactionScope.class}).register(new Class[]{MapEntryValue.class}).register(new Class[]{MapEntryValue.Type.class}).register(new Class[]{new HashMap().keySet().getClass()}).register(new Class[]{DefaultIterator.class}).build());
        this.map = this.createMap();
    }

    protected Map<K, MapEntryValue> createMap() {
        return Maps.newConcurrentMap();
    }

    protected Map<K, MapEntryValue> entries() {
        return this.map;
    }

    public Serializer serializer() {
        return this.serializer;
    }

    public void backup(BackupOutput writer) {
        writer.writeObject(this.listeners);
        writer.writeObject(this.preparedKeys);
        writer.writeObject((Object)Maps.newHashMap(this.entries()));
        writer.writeObject(this.activeTransactions);
        writer.writeLong(this.currentVersion);
        writer.writeObject(this.entryIterators);
    }

    public void restore(BackupInput reader) {
        this.listeners = (Set)reader.readObject();
        this.preparedKeys = (Set)reader.readObject();
        Map map = (Map)reader.readObject();
        this.map = this.createMap();
        this.map.putAll(map);
        this.activeTransactions = (Map)reader.readObject();
        this.currentVersion = reader.readLong();
        this.entryIterators = (Map)reader.readObject();
        map.forEach((key, value) -> {
            if (value.ttl() > 0L) {
                value.timer = this.getScheduler().schedule(Duration.ofMillis(value.ttl() - (this.getWallClock().getTime().unixTimestamp() - value.created())), () -> {
                    this.entries().remove(key, value);
                    this.publish(new AtomicMapEvent<Object, byte[]>(AtomicMapEvent.Type.REMOVE, key, null, this.toVersioned((MapEntryValue)value)));
                });
            }
        });
    }

    @Override
    public boolean containsKey(K key) {
        MapEntryValue value = this.entries().get(key);
        return value != null && value.type() != MapEntryValue.Type.TOMBSTONE;
    }

    @Override
    public boolean containsKeys(Collection<? extends K> keys) {
        for (K key : keys) {
            if (this.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsValue(byte[] value) {
        return this.entries().values().stream().filter(v -> v.type() != MapEntryValue.Type.TOMBSTONE).anyMatch(v -> Arrays.equals(v.value, value));
    }

    @Override
    public Versioned<byte[]> get(K key) {
        return this.toVersioned(this.entries().get(key));
    }

    @Override
    public Map<K, Versioned<byte[]>> getAllPresent(Set<K> keys) {
        return this.entries().entrySet().stream().filter(entry -> ((MapEntryValue)entry.getValue()).type() != MapEntryValue.Type.TOMBSTONE && keys.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, o -> this.toVersioned((MapEntryValue)o.getValue())));
    }

    @Override
    public Versioned<byte[]> getOrDefault(K key, byte[] defaultValue) {
        MapEntryValue value = this.entries().get(key);
        if (value == null) {
            return new Versioned((Object)defaultValue, 0L);
        }
        if (value.type() == MapEntryValue.Type.TOMBSTONE) {
            return new Versioned((Object)defaultValue, value.version);
        }
        return new Versioned((Object)value.value(), value.version);
    }

    @Override
    public int size() {
        return (int)this.entries().values().stream().filter(value -> value.type() != MapEntryValue.Type.TOMBSTONE).count();
    }

    @Override
    public boolean isEmpty() {
        return this.entries().values().stream().noneMatch(value -> value.type() != MapEntryValue.Type.TOMBSTONE);
    }

    @Override
    public Set<K> keySet() {
        return this.entries().entrySet().stream().filter(entry -> ((MapEntryValue)entry.getValue()).type() != MapEntryValue.Type.TOMBSTONE).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public Collection<Versioned<byte[]>> values() {
        return this.entries().entrySet().stream().filter(entry -> ((MapEntryValue)entry.getValue()).type() != MapEntryValue.Type.TOMBSTONE).map(entry -> this.toVersioned((MapEntryValue)entry.getValue())).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<K, Versioned<byte[]>>> entrySet() {
        return this.entries().entrySet().stream().filter(entry -> ((MapEntryValue)entry.getValue()).type() != MapEntryValue.Type.TOMBSTONE).map(e -> Maps.immutableEntry(e.getKey(), this.toVersioned((MapEntryValue)e.getValue()))).collect(Collectors.toSet());
    }

    protected boolean valuesEqual(MapEntryValue oldValue, MapEntryValue newValue) {
        return oldValue == null && newValue == null || oldValue != null && newValue != null && this.valuesEqual(oldValue.value(), newValue.value());
    }

    protected boolean valuesEqual(byte[] oldValue, byte[] newValue) {
        return oldValue == null && newValue == null || oldValue != null && newValue != null && Arrays.equals(oldValue, newValue);
    }

    protected boolean valueIsNull(MapEntryValue value) {
        return value == null || value.type() == MapEntryValue.Type.TOMBSTONE;
    }

    protected void putValue(K key, MapEntryValue value) {
        MapEntryValue oldValue = this.entries().put(key, value);
        this.cancelTtl(oldValue);
        this.scheduleTtl(key, value);
    }

    protected void scheduleTtl(K key, MapEntryValue value) {
        if (value.ttl() > 0L) {
            value.timer = this.getScheduler().schedule(Duration.ofMillis(value.ttl()), () -> {
                this.entries().remove(key, value);
                this.publish(new AtomicMapEvent<Object, byte[]>(AtomicMapEvent.Type.REMOVE, key, null, this.toVersioned(value)));
            });
        }
    }

    protected void cancelTtl(MapEntryValue value) {
        if (value != null && value.timer != null) {
            value.timer.cancel();
        }
    }

    @Override
    public MapEntryUpdateResult<K, byte[]> put(K key, byte[] value, long ttl) {
        MapEntryValue oldValue = this.entries().get(key);
        MapEntryValue newValue = new MapEntryValue(MapEntryValue.Type.VALUE, this.getCurrentIndex(), value, this.getWallClock().getTime().unixTimestamp(), ttl);
        if (this.valueIsNull(oldValue)) {
            if (this.preparedKeys.contains(key)) {
                return new MapEntryUpdateResult<K, byte[]>(MapEntryUpdateResult.Status.WRITE_LOCK, this.getCurrentIndex(), key, this.toVersioned(oldValue));
            }
            this.putValue(key, newValue);
            Versioned<byte[]> result = this.toVersioned(oldValue);
            this.publish(new AtomicMapEvent<K, byte[]>(AtomicMapEvent.Type.INSERT, key, this.toVersioned(newValue), result));
            return new MapEntryUpdateResult<K, byte[]>(MapEntryUpdateResult.Status.OK, this.getCurrentIndex(), key, result);
        }
        if (!this.valuesEqual(oldValue, newValue)) {
            if (this.preparedKeys.contains(key)) {
                return new MapEntryUpdateResult<K, byte[]>(MapEntryUpdateResult.Status.WRITE_LOCK, this.getCurrentIndex(), key, this.toVersioned(oldValue));
            }
            this.putValue(key, newValue);
            Versioned<byte[]> result = this.toVersioned(oldValue);
            this.publish(new AtomicMapEvent<K, byte[]>(AtomicMapEvent.Type.UPDATE, key, this.toVersioned(newValue), result));
            return new MapEntryUpdateResult<K, byte[]>(MapEntryUpdateResult.Status.OK, this.getCurrentIndex(), key, result);
        }
        return new MapEntryUpdateResult<K, byte[]>(MapEntryUpdateResult.Status.NOOP, this.getCurrentIndex(), key, this.toVersioned(oldValue));
    }

    @Override
    public MapEntryUpdateResult<K, byte[]> putIfAbsent(K key, byte[] value, long ttl) {
        MapEntryValue oldValue = this.entries().get(key);
        if (this.valueIsNull(oldValue)) {
            if (this.preparedKeys.contains(key)) {
                return new MapEntryUpdateResult<K, byte[]>(MapEntryUpdateResult.Status.WRITE_LOCK, this.getCurrentIndex(), key, this.toVersioned(oldValue));
            }
            MapEntryValue newValue = new MapEntryValue(MapEntryValue.Type.VALUE, this.getCurrentIndex(), value, this.getWallClock().getTime().unixTimestamp(), ttl);
            this.putValue(key, newValue);
            Versioned<byte[]> result = this.toVersioned(newValue);
            this.publish(new AtomicMapEvent<K, byte[]>(AtomicMapEvent.Type.INSERT, key, result, null));
            return new MapEntryUpdateResult(MapEntryUpdateResult.Status.OK, this.getCurrentIndex(), key, null);
        }
        return new MapEntryUpdateResult<K, byte[]>(MapEntryUpdateResult.Status.PRECONDITION_FAILED, this.getCurrentIndex(), key, this.toVersioned(oldValue));
    }

    @Override
    public MapEntryUpdateResult<K, byte[]> putAndGet(K key, byte[] value, long ttl) {
        MapEntryValue oldValue = this.entries().get(key);
        MapEntryValue newValue = new MapEntryValue(MapEntryValue.Type.VALUE, this.getCurrentIndex(), value, this.getWallClock().getTime().unixTimestamp(), ttl);
        if (this.valueIsNull(oldValue)) {
            if (this.preparedKeys.contains(key)) {
                return new MapEntryUpdateResult<K, byte[]>(MapEntryUpdateResult.Status.WRITE_LOCK, this.getCurrentIndex(), key, this.toVersioned(oldValue));
            }
            this.putValue(key, newValue);
            Versioned<byte[]> result = this.toVersioned(newValue);
            this.publish(new AtomicMapEvent<K, byte[]>(AtomicMapEvent.Type.INSERT, key, result, null));
            return new MapEntryUpdateResult<K, byte[]>(MapEntryUpdateResult.Status.OK, this.getCurrentIndex(), key, result);
        }
        if (!this.valuesEqual(oldValue, newValue)) {
            if (this.preparedKeys.contains(key)) {
                return new MapEntryUpdateResult<K, byte[]>(MapEntryUpdateResult.Status.WRITE_LOCK, this.getCurrentIndex(), key, this.toVersioned(oldValue));
            }
            this.putValue(key, newValue);
            Versioned<byte[]> result = this.toVersioned(newValue);
            this.publish(new AtomicMapEvent<K, byte[]>(AtomicMapEvent.Type.UPDATE, key, result, this.toVersioned(oldValue)));
            return new MapEntryUpdateResult<K, byte[]>(MapEntryUpdateResult.Status.OK, this.getCurrentIndex(), key, result);
        }
        return new MapEntryUpdateResult<K, byte[]>(MapEntryUpdateResult.Status.NOOP, this.getCurrentIndex(), key, this.toVersioned(oldValue));
    }

    private MapEntryUpdateResult<K, byte[]> removeIf(long index, K key, Predicate<MapEntryValue> predicate) {
        MapEntryValue value = this.entries().get(key);
        if (this.valueIsNull(value) || !predicate.test(value)) {
            return new MapEntryUpdateResult(MapEntryUpdateResult.Status.PRECONDITION_FAILED, index, key, null);
        }
        if (this.preparedKeys.contains(key)) {
            return new MapEntryUpdateResult(MapEntryUpdateResult.Status.WRITE_LOCK, index, key, null);
        }
        if (this.activeTransactions.isEmpty()) {
            this.entries().remove(key);
        } else {
            this.entries().put(key, new MapEntryValue(MapEntryValue.Type.TOMBSTONE, index, null, 0L, 0L));
        }
        this.cancelTtl(value);
        Versioned<byte[]> result = this.toVersioned(value);
        this.publish(new AtomicMapEvent<K, byte[]>(AtomicMapEvent.Type.REMOVE, key, null, result));
        return new MapEntryUpdateResult<K, byte[]>(MapEntryUpdateResult.Status.OK, index, key, result);
    }

    @Override
    public MapEntryUpdateResult<K, byte[]> remove(K key) {
        return this.removeIf(this.getCurrentIndex(), key, v -> true);
    }

    @Override
    public MapEntryUpdateResult<K, byte[]> remove(K key, byte[] value) {
        return this.removeIf(this.getCurrentIndex(), key, v -> this.valuesEqual((MapEntryValue)v, new MapEntryValue(MapEntryValue.Type.VALUE, this.getCurrentIndex(), value, this.getWallClock().getTime().unixTimestamp(), 0L)));
    }

    @Override
    public MapEntryUpdateResult<K, byte[]> remove(K key, long version) {
        return this.removeIf(this.getCurrentIndex(), key, v -> v.version() == version);
    }

    private MapEntryUpdateResult<K, byte[]> replaceIf(long index, K key, MapEntryValue newValue, Predicate<MapEntryValue> predicate) {
        MapEntryValue oldValue = this.entries().get(key);
        if (this.valueIsNull(oldValue) || !predicate.test(oldValue)) {
            return new MapEntryUpdateResult<K, byte[]>(MapEntryUpdateResult.Status.PRECONDITION_FAILED, index, key, this.toVersioned(oldValue));
        }
        if (this.preparedKeys.contains(key)) {
            return new MapEntryUpdateResult(MapEntryUpdateResult.Status.WRITE_LOCK, index, key, null);
        }
        this.putValue(key, newValue);
        Versioned<byte[]> result = this.toVersioned(oldValue);
        this.publish(new AtomicMapEvent<K, byte[]>(AtomicMapEvent.Type.UPDATE, key, this.toVersioned(newValue), result));
        return new MapEntryUpdateResult<K, byte[]>(MapEntryUpdateResult.Status.OK, index, key, result);
    }

    @Override
    public MapEntryUpdateResult<K, byte[]> replace(K key, byte[] value) {
        MapEntryValue entryValue = new MapEntryValue(MapEntryValue.Type.VALUE, this.getCurrentIndex(), value, this.getWallClock().getTime().unixTimestamp(), 0L);
        return this.replaceIf(this.getCurrentIndex(), key, entryValue, v -> true);
    }

    @Override
    public MapEntryUpdateResult<K, byte[]> replace(K key, byte[] oldValue, byte[] newValue) {
        MapEntryValue entryValue = new MapEntryValue(MapEntryValue.Type.VALUE, this.getCurrentIndex(), newValue, this.getWallClock().getTime().unixTimestamp(), 0L);
        return this.replaceIf(this.getCurrentIndex(), key, entryValue, v -> this.valuesEqual(v.value(), oldValue));
    }

    @Override
    public MapEntryUpdateResult<K, byte[]> replace(K key, long oldVersion, byte[] newValue) {
        MapEntryValue value = new MapEntryValue(MapEntryValue.Type.VALUE, this.getCurrentIndex(), newValue, this.getWallClock().getTime().unixTimestamp(), 0L);
        return this.replaceIf(this.getCurrentIndex(), key, value, v -> v.version() == oldVersion);
    }

    @Override
    public void clear() {
        Iterator<Map.Entry<K, MapEntryValue>> iterator = this.entries().entrySet().iterator();
        HashMap<K, MapEntryValue> entriesToAdd = new HashMap<K, MapEntryValue>();
        while (iterator.hasNext()) {
            Map.Entry<K, MapEntryValue> entry = iterator.next();
            K key = entry.getKey();
            MapEntryValue value = entry.getValue();
            if (this.valueIsNull(value)) continue;
            Versioned removedValue = new Versioned((Object)value.value(), value.version());
            this.publish(new AtomicMapEvent(AtomicMapEvent.Type.REMOVE, key, null, removedValue));
            this.cancelTtl(value);
            if (this.activeTransactions.isEmpty()) {
                iterator.remove();
                continue;
            }
            entriesToAdd.put(key, new MapEntryValue(MapEntryValue.Type.TOMBSTONE, value.version, null, 0L, 0L));
        }
        this.entries().putAll(entriesToAdd);
    }

    @Override
    public IteratorBatch<K> iterateKeys() {
        return this.iterate(x$0 -> new DefaultIterator((long)x$0), (k, v) -> k);
    }

    @Override
    public IteratorBatch<K> nextKeys(long iteratorId, int position) {
        return this.next(iteratorId, position, (k, v) -> k);
    }

    @Override
    public void closeKeys(long iteratorId) {
        this.close(iteratorId);
    }

    @Override
    public IteratorBatch<Versioned<byte[]>> iterateValues() {
        return this.iterate(x$0 -> new DefaultIterator((long)x$0), (k, v) -> v);
    }

    @Override
    public IteratorBatch<Versioned<byte[]>> nextValues(long iteratorId, int position) {
        return this.next(iteratorId, position, (k, v) -> v);
    }

    @Override
    public void closeValues(long iteratorId) {
        this.close(iteratorId);
    }

    @Override
    public IteratorBatch<Map.Entry<K, Versioned<byte[]>>> iterateEntries() {
        return this.iterate(x$0 -> new DefaultIterator((long)x$0), Maps::immutableEntry);
    }

    @Override
    public IteratorBatch<Map.Entry<K, Versioned<byte[]>>> nextEntries(long iteratorId, int position) {
        return this.next(iteratorId, position, Maps::immutableEntry);
    }

    @Override
    public void closeEntries(long iteratorId) {
        this.close(iteratorId);
    }

    protected <T> IteratorBatch<T> iterate(Function<Long, IteratorContext> contextFactory, BiFunction<K, Versioned<byte[]>, T> function) {
        IteratorContext iterator = contextFactory.apply((Long)this.getCurrentSession().sessionId().id());
        if (!iterator.iterator().hasNext()) {
            return null;
        }
        long iteratorId = this.getCurrentIndex();
        this.entryIterators.put(iteratorId, iterator);
        IteratorBatch<T> batch = this.next(iteratorId, 0, function);
        if (batch.complete()) {
            this.entryIterators.remove(iteratorId);
        }
        return batch;
    }

    protected <T> IteratorBatch<T> next(long iteratorId, int position, BiFunction<K, Versioned<byte[]>, T> function) {
        IteratorContext context = this.entryIterators.get(iteratorId);
        if (context == null) {
            return null;
        }
        ArrayList<T> entries = new ArrayList<T>();
        int size = 0;
        while (context.iterator().hasNext()) {
            context.incrementPosition();
            if (context.position() <= position) continue;
            Map.Entry entry = context.iterator().next();
            entries.add(function.apply(entry.getKey(), this.toVersioned(entry.getValue())));
            if ((size += entry.getValue().value().length) < 32768) continue;
            break;
        }
        if (entries.isEmpty()) {
            return null;
        }
        return new IteratorBatch(iteratorId, context.position, entries, !context.iterator().hasNext());
    }

    protected void close(long iteratorId) {
        this.entryIterators.remove(iteratorId);
    }

    @Override
    public void listen() {
        this.listeners.add(this.getCurrentSession().sessionId());
    }

    @Override
    public void unlisten() {
        this.listeners.remove(this.getCurrentSession().sessionId());
    }

    @Override
    public long begin(TransactionId transactionId) {
        long version = this.getCurrentIndex();
        this.activeTransactions.put(transactionId, new TransactionScope(version));
        return version;
    }

    @Override
    public PrepareResult prepareAndCommit(TransactionLog<MapUpdate<K, byte[]>> transactionLog) {
        TransactionId transactionId = transactionLog.transactionId();
        PrepareResult prepareResult = this.prepare(transactionLog);
        TransactionScope<K> transactionScope = this.activeTransactions.remove((Object)transactionId);
        if (prepareResult == PrepareResult.OK) {
            this.currentVersion = this.getCurrentIndex();
            transactionScope = transactionScope.prepared(transactionLog);
            this.commitTransaction(transactionScope);
        }
        this.discardTombstones();
        return prepareResult;
    }

    @Override
    public PrepareResult prepare(TransactionLog<MapUpdate<K, byte[]>> transactionLog) {
        try {
            for (MapUpdate<K, byte[]> record2 : transactionLog.records()) {
                K key = record2.key();
                if (record2.type() == MapUpdate.Type.VERSION_MATCH && key == null) {
                    if (record2.version() <= this.currentVersion) continue;
                    return PrepareResult.OPTIMISTIC_LOCK_FAILURE;
                }
                if (this.preparedKeys.contains(key)) {
                    return PrepareResult.CONCURRENT_TRANSACTION;
                }
                MapEntryValue existingValue = this.entries().get(key);
                if (!(existingValue == null ? record2.type() != MapUpdate.Type.PUT_IF_ABSENT && record2.version() != transactionLog.version() : existingValue.version() > record2.version())) continue;
                return PrepareResult.OPTIMISTIC_LOCK_FAILURE;
            }
            transactionLog.records().forEach(record -> {
                if (record.type() != MapUpdate.Type.VERSION_MATCH) {
                    this.preparedKeys.add(record.key());
                }
            });
            TransactionScope<K> transactionScope = this.activeTransactions.get((Object)transactionLog.transactionId());
            if (transactionScope == null) {
                this.activeTransactions.put(transactionLog.transactionId(), new TransactionScope(transactionLog.version(), transactionLog));
                return PrepareResult.PARTIAL_FAILURE;
            }
            this.activeTransactions.put(transactionLog.transactionId(), transactionScope.prepared(transactionLog));
            return PrepareResult.OK;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public CommitResult commit(TransactionId transactionId) {
        TransactionScope<K> transactionScope = this.activeTransactions.remove((Object)transactionId);
        if (transactionScope == null) {
            return CommitResult.UNKNOWN_TRANSACTION_ID;
        }
        try {
            this.currentVersion = this.getCurrentIndex();
            CommitResult commitResult = this.commitTransaction(transactionScope);
            return commitResult;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            this.discardTombstones();
        }
    }

    private CommitResult commitTransaction(TransactionScope<K> transactionScope) {
        TransactionLog<MapUpdate<K, byte[]>> transactionLog = transactionScope.transactionLog();
        boolean retainTombstones = !this.activeTransactions.isEmpty();
        ArrayList eventsToPublish = Lists.newArrayList();
        for (MapUpdate<K, byte[]> record : transactionLog.records()) {
            AtomicMapEvent<K, byte[]> event;
            if (record.type() == MapUpdate.Type.VERSION_MATCH) continue;
            K key = record.key();
            Preconditions.checkState((boolean)this.preparedKeys.remove(key), (Object)"key is not prepared");
            if (record.type() == MapUpdate.Type.LOCK) continue;
            MapEntryValue previousValue = this.entries().remove(key);
            this.cancelTtl(previousValue);
            MapEntryValue newValue = null;
            if (record.type() != MapUpdate.Type.REMOVE_IF_VERSION_MATCH) {
                newValue = new MapEntryValue(MapEntryValue.Type.VALUE, this.currentVersion, record.value(), 0L, 0L);
            } else if (retainTombstones) {
                newValue = new MapEntryValue(MapEntryValue.Type.TOMBSTONE, this.currentVersion, null, 0L, 0L);
            }
            if (newValue != null) {
                this.entries().put(key, newValue);
                event = !this.valueIsNull(newValue) ? (!this.valueIsNull(previousValue) ? new AtomicMapEvent<K, byte[]>(AtomicMapEvent.Type.UPDATE, key, this.toVersioned(newValue), this.toVersioned(previousValue)) : new AtomicMapEvent<K, byte[]>(AtomicMapEvent.Type.INSERT, key, this.toVersioned(newValue), null)) : new AtomicMapEvent<K, byte[]>(AtomicMapEvent.Type.REMOVE, key, null, this.toVersioned(previousValue));
            } else {
                event = new AtomicMapEvent<K, byte[]>(AtomicMapEvent.Type.REMOVE, key, null, this.toVersioned(previousValue));
            }
            eventsToPublish.add(event);
        }
        this.publish(eventsToPublish);
        return CommitResult.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RollbackResult rollback(TransactionId transactionId) {
        TransactionScope<K> transactionScope = this.activeTransactions.remove((Object)transactionId);
        if (transactionScope == null) {
            return RollbackResult.UNKNOWN_TRANSACTION_ID;
        }
        if (!transactionScope.isPrepared()) {
            this.discardTombstones();
            return RollbackResult.OK;
        }
        try {
            transactionScope.transactionLog().records().forEach(record -> {
                if (record.type() != MapUpdate.Type.VERSION_MATCH) {
                    this.preparedKeys.remove(record.key());
                }
            });
            RollbackResult rollbackResult = RollbackResult.OK;
            return rollbackResult;
        }
        finally {
            this.discardTombstones();
        }
    }

    private void discardTombstones() {
        if (this.activeTransactions.isEmpty()) {
            Iterator<Map.Entry<K, MapEntryValue>> iterator = this.entries().entrySet().iterator();
            while (iterator.hasNext()) {
                MapEntryValue value = iterator.next().getValue();
                if (value.type() != MapEntryValue.Type.TOMBSTONE) continue;
                iterator.remove();
            }
        } else {
            long lowWaterMark = this.activeTransactions.values().stream().mapToLong(TransactionScope::version).min().getAsLong();
            Iterator<Map.Entry<K, MapEntryValue>> iterator = this.entries().entrySet().iterator();
            while (iterator.hasNext()) {
                MapEntryValue value = iterator.next().getValue();
                if (value.type() != MapEntryValue.Type.TOMBSTONE || value.version >= lowWaterMark) continue;
                iterator.remove();
            }
        }
    }

    protected Versioned<byte[]> toVersioned(MapEntryValue value) {
        return value != null && value.type() != MapEntryValue.Type.TOMBSTONE ? new Versioned((Object)value.value(), value.version()) : null;
    }

    private void publish(AtomicMapEvent<K, byte[]> event) {
        this.publish(Lists.newArrayList((Object[])new AtomicMapEvent[]{event}));
    }

    private void publish(List<AtomicMapEvent<K, byte[]>> events) {
        this.listeners.forEach(listener -> events.forEach(event -> this.getSession((SessionId)listener).accept(client -> client.change(event))));
    }

    public void onExpire(Session session) {
        this.listeners.remove(session.sessionId());
        this.entryIterators.entrySet().removeIf(entry -> ((IteratorContext)entry.getValue()).sessionId == (Long)session.sessionId().id());
    }

    public void onClose(Session session) {
        this.listeners.remove(session.sessionId());
        this.entryIterators.entrySet().removeIf(entry -> ((IteratorContext)entry.getValue()).sessionId == (Long)session.sessionId().id());
    }

    protected class DefaultIterator
    extends IteratorContext {
        public DefaultIterator(long sessionId) {
            super(sessionId);
        }

        @Override
        protected Iterator<Map.Entry<K, MapEntryValue>> create() {
            return AbstractAtomicMapService.this.entries().entrySet().iterator();
        }
    }

    protected abstract class IteratorContext {
        private final long sessionId;
        private int position = 0;
        private transient Iterator<Map.Entry<K, MapEntryValue>> iterator;

        public IteratorContext(long sessionId) {
            this.sessionId = sessionId;
        }

        protected abstract Iterator<Map.Entry<K, MapEntryValue>> create();

        public long sessionId() {
            return this.sessionId;
        }

        public int position() {
            return this.position;
        }

        public void incrementPosition() {
            ++this.position;
        }

        public Iterator<Map.Entry<K, MapEntryValue>> iterator() {
            if (this.iterator == null) {
                this.iterator = this.create();
            }
            return this.iterator;
        }
    }

    protected static final class TransactionScope<K> {
        private final long version;
        private final TransactionLog<MapUpdate<K, byte[]>> transactionLog;

        private TransactionScope(long version) {
            this(version, (TransactionLog<MapUpdate<K, byte[]>>)null);
        }

        private TransactionScope(long version, TransactionLog<MapUpdate<K, byte[]>> transactionLog) {
            this.version = version;
            this.transactionLog = transactionLog;
        }

        long version() {
            return this.version;
        }

        boolean isPrepared() {
            return this.transactionLog != null;
        }

        TransactionLog<MapUpdate<K, byte[]>> transactionLog() {
            Preconditions.checkState((boolean)this.isPrepared());
            return this.transactionLog;
        }

        TransactionScope<K> prepared(TransactionLog<MapUpdate<K, byte[]>> transactionLog) {
            return new TransactionScope<K>(this.version, transactionLog);
        }
    }

    protected static class MapEntryValue {
        final Type type;
        final long version;
        final byte[] value;
        final long created;
        final long ttl;
        transient Scheduled timer;

        MapEntryValue(Type type, long version, byte[] value, long created, long ttl) {
            this.type = type;
            this.version = version;
            this.value = value;
            this.created = created;
            this.ttl = ttl;
        }

        public Type type() {
            return this.type;
        }

        public long version() {
            return this.version;
        }

        public byte[] value() {
            return this.value;
        }

        public long created() {
            return this.created;
        }

        public long ttl() {
            return this.ttl;
        }

        public static enum Type {
            VALUE,
            TOMBSTONE;

        }
    }
}

