/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import io.atomix.core.iterator.impl.IteratorBatch;
import io.atomix.core.map.impl.MapEntryUpdateResult;
import io.atomix.core.map.impl.MapUpdate;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionLog;
import io.atomix.core.transaction.impl.CommitResult;
import io.atomix.core.transaction.impl.PrepareResult;
import io.atomix.core.transaction.impl.RollbackResult;
import io.atomix.primitive.operation.Command;
import io.atomix.primitive.operation.Query;
import io.atomix.utils.time.Versioned;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public interface AtomicMapService<K> {
    @Query
    public int size();

    @Query
    public boolean isEmpty();

    @Query
    public boolean containsKey(K var1);

    @Query
    public boolean containsKeys(Collection<? extends K> var1);

    @Query
    public boolean containsValue(byte[] var1);

    @Query
    public Versioned<byte[]> get(K var1);

    @Query
    public Map<K, Versioned<byte[]>> getAllPresent(Set<K> var1);

    @Query
    public Versioned<byte[]> getOrDefault(K var1, byte[] var2);

    @Command
    default public MapEntryUpdateResult<K, byte[]> put(K key, byte[] value) {
        return this.put(key, value, 0L);
    }

    @Command(value="putWithTtl")
    public MapEntryUpdateResult<K, byte[]> put(K var1, byte[] var2, long var3);

    @Command
    default public MapEntryUpdateResult<K, byte[]> putAndGet(K key, byte[] value) {
        return this.putAndGet(key, value, 0L);
    }

    @Command(value="putAndGetWithTtl")
    public MapEntryUpdateResult<K, byte[]> putAndGet(K var1, byte[] var2, long var3);

    @Command
    public MapEntryUpdateResult<K, byte[]> remove(K var1);

    @Command
    public void clear();

    @Query
    public Set<K> keySet();

    @Query
    public Collection<Versioned<byte[]>> values();

    @Query
    public Set<Map.Entry<K, Versioned<byte[]>>> entrySet();

    @Command
    default public MapEntryUpdateResult<K, byte[]> putIfAbsent(K key, byte[] value) {
        return this.putIfAbsent(key, value, 0L);
    }

    @Command(value="putIfAbsentWithTtl")
    public MapEntryUpdateResult<K, byte[]> putIfAbsent(K var1, byte[] var2, long var3);

    @Command(value="removeValue")
    public MapEntryUpdateResult<K, byte[]> remove(K var1, byte[] var2);

    @Command(value="removeVersion")
    public MapEntryUpdateResult<K, byte[]> remove(K var1, long var2);

    @Command(value="replace")
    public MapEntryUpdateResult<K, byte[]> replace(K var1, byte[] var2);

    @Command(value="replaceValue")
    public MapEntryUpdateResult<K, byte[]> replace(K var1, byte[] var2, byte[] var3);

    @Command(value="replaceVersion")
    public MapEntryUpdateResult<K, byte[]> replace(K var1, long var2, byte[] var4);

    @Command
    public IteratorBatch<K> iterateKeys();

    @Query
    public IteratorBatch<K> nextKeys(long var1, int var3);

    @Command
    public void closeKeys(long var1);

    @Command
    public IteratorBatch<Versioned<byte[]>> iterateValues();

    @Query
    public IteratorBatch<Versioned<byte[]>> nextValues(long var1, int var3);

    @Command
    public void closeValues(long var1);

    @Command
    public IteratorBatch<Map.Entry<K, Versioned<byte[]>>> iterateEntries();

    @Query
    public IteratorBatch<Map.Entry<K, Versioned<byte[]>>> nextEntries(long var1, int var3);

    @Command
    public void closeEntries(long var1);

    @Command
    public void listen();

    @Command
    public void unlisten();

    @Command
    public long begin(TransactionId var1);

    @Command
    public PrepareResult prepareAndCommit(TransactionLog<MapUpdate<K, byte[]>> var1);

    @Command
    public PrepareResult prepare(TransactionLog<MapUpdate<K, byte[]>> var1);

    @Command
    public CommitResult commit(TransactionId var1);

    @Command
    public RollbackResult rollback(TransactionId var1);
}

