/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import com.google.common.base.Throwables;
import io.atomix.core.collection.DistributedCollection;
import io.atomix.core.collection.impl.BlockingDistributedCollection;
import io.atomix.core.map.AsyncDistributedMap;
import io.atomix.core.map.DistributedMap;
import io.atomix.core.map.MapEventListener;
import io.atomix.core.set.DistributedSet;
import io.atomix.core.set.impl.BlockingDistributedSet;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.Synchronous;
import io.atomix.utils.concurrent.Retries;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class BlockingDistributedMap<K, V>
extends Synchronous<AsyncDistributedMap<K, V>>
implements DistributedMap<K, V> {
    private static final int MAX_DELAY_BETWEEN_RETRY_MILLS = 50;
    private final AsyncDistributedMap<K, V> asyncMap;
    private final long operationTimeoutMillis;

    public BlockingDistributedMap(AsyncDistributedMap<K, V> asyncMap, long operationTimeoutMillis) {
        super(asyncMap);
        this.asyncMap = asyncMap;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public int size() {
        return this.complete(this.asyncMap.size());
    }

    @Override
    public boolean isEmpty() {
        return this.complete(this.asyncMap.isEmpty());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.complete(this.asyncMap.containsKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.complete(this.asyncMap.containsValue(value));
    }

    @Override
    public V put(K key, V value) {
        return this.complete(this.asyncMap.put(key, value));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.complete(this.asyncMap.putAll(m));
    }

    @Override
    public V get(Object key) {
        return this.complete(this.asyncMap.get(key));
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.complete(this.asyncMap.getOrDefault(key, defaultValue));
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return (V)Retries.retryable(() -> this.complete(this.asyncMap.computeIfAbsent(key, mappingFunction)), PrimitiveException.ConcurrentModification.class, (int)Integer.MAX_VALUE, (int)50).get();
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)Retries.retryable(() -> this.complete(this.asyncMap.computeIfPresent(key, remappingFunction)), PrimitiveException.ConcurrentModification.class, (int)Integer.MAX_VALUE, (int)50).get();
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)Retries.retryable(() -> this.complete(this.asyncMap.compute(key, remappingFunction)), PrimitiveException.ConcurrentModification.class, (int)Integer.MAX_VALUE, (int)50).get();
    }

    @Override
    public V remove(Object key) {
        return this.complete(this.asyncMap.remove(key));
    }

    @Override
    public void clear() {
        this.complete(this.asyncMap.clear());
    }

    @Override
    public DistributedSet<K> keySet() {
        return new BlockingDistributedSet<K>(this.asyncMap.keySet(), this.operationTimeoutMillis);
    }

    @Override
    public DistributedCollection<V> values() {
        return new BlockingDistributedCollection<V>(this.asyncMap.values(), this.operationTimeoutMillis);
    }

    @Override
    public DistributedSet<Map.Entry<K, V>> entrySet() {
        return new BlockingDistributedSet<Map.Entry<K, V>>(this.asyncMap.entrySet(), this.operationTimeoutMillis);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.complete(this.asyncMap.remove(key, value));
    }

    @Override
    public V replace(K key, V value) {
        return this.complete(this.asyncMap.replace(key, value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.complete(this.asyncMap.replace(key, oldValue, newValue));
    }

    @Override
    public void addListener(MapEventListener<K, V> listener, Executor executor) {
        this.complete(this.asyncMap.addListener(listener, executor));
    }

    @Override
    public void removeListener(MapEventListener<K, V> listener) {
        this.complete(this.asyncMap.removeListener(listener));
    }

    public void addStateChangeListener(Consumer<PrimitiveState> listener) {
        this.asyncMap.addStateChangeListener(listener);
    }

    public void removeStateChangeListener(Consumer<PrimitiveState> listener) {
        this.asyncMap.removeStateChangeListener(listener);
    }

    @Override
    public AsyncDistributedMap<K, V> async() {
        return this.asyncMap;
    }

    protected <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            Throwable cause = Throwables.getRootCause((Throwable)e);
            if (cause instanceof PrimitiveException) {
                throw (PrimitiveException)cause;
            }
            throw new PrimitiveException(cause);
        }
    }
}

