/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.semaphore.impl;

import com.google.common.base.Throwables;
import io.atomix.core.semaphore.AsyncDistributedSemaphore;
import io.atomix.core.semaphore.DistributedSemaphore;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class BlockingDistributedSemaphore
extends DistributedSemaphore {
    private final AsyncDistributedSemaphore asyncSemaphore;
    private final Duration timeout;

    public BlockingDistributedSemaphore(AsyncDistributedSemaphore asyncSemaphore, Duration timeout) {
        this.asyncSemaphore = asyncSemaphore;
        this.timeout = timeout;
    }

    public String name() {
        return this.asyncSemaphore.name();
    }

    public PrimitiveType type() {
        return this.asyncSemaphore.type();
    }

    public PrimitiveProtocol protocol() {
        return this.asyncSemaphore.protocol();
    }

    @Override
    public void acquire() throws InterruptedException {
        this.completeInterruptibly(this.asyncSemaphore.acquire(), 1);
    }

    @Override
    public void acquireUninterruptibly() {
        this.complete(this.asyncSemaphore.acquire(), 1);
    }

    @Override
    public void acquire(int permits) throws InterruptedException {
        this.completeInterruptibly(this.asyncSemaphore.acquire(permits), permits);
    }

    @Override
    public void acquireUninterruptibly(int permits) {
        this.complete(this.asyncSemaphore.acquire(permits), permits);
    }

    @Override
    public boolean tryAcquire(int permits) {
        return this.complete(this.asyncSemaphore.tryAcquire(permits), permits);
    }

    @Override
    public boolean tryAcquire(int permits, Duration timeout) throws InterruptedException {
        return this.complete(this.asyncSemaphore.tryAcquire(permits, timeout), permits);
    }

    @Override
    public boolean tryAcquire() {
        return this.complete(this.asyncSemaphore.tryAcquire(), 1);
    }

    @Override
    public boolean tryAcquire(Duration timeout) throws InterruptedException {
        return this.complete(this.asyncSemaphore.tryAcquire(timeout), 1);
    }

    @Override
    public void release() {
        this.complete(this.asyncSemaphore.release());
    }

    @Override
    public void release(int permits) {
        this.complete(this.asyncSemaphore.release(permits));
    }

    @Override
    public int availablePermits() {
        return this.complete(this.asyncSemaphore.availablePermits());
    }

    @Override
    public int drainPermits() {
        return this.complete(this.asyncSemaphore.drainPermits());
    }

    @Override
    protected void increasePermits(int increase) {
        this.complete(this.asyncSemaphore.increasePermits(increase));
    }

    @Override
    protected void reducePermits(int reduction) {
        this.complete(this.asyncSemaphore.reducePermits(reduction));
    }

    @Override
    public boolean isFair() {
        return true;
    }

    @Override
    public AsyncDistributedSemaphore async() {
        return this.asyncSemaphore;
    }

    public void close() {
        this.complete(this.asyncSemaphore.close());
    }

    public void delete() {
        this.complete(this.asyncSemaphore.delete());
    }

    private <T> T complete(CompletableFuture<T> future) {
        return this.complete(future, 0);
    }

    private <T> T complete(CompletableFuture<T> future, int acquirePermits) {
        AtomicBoolean needRelease = new AtomicBoolean(false);
        try {
            return ((CompletableFuture)future.thenApply(value -> {
                if (needRelease.get() && acquirePermits > 0) {
                    this.asyncSemaphore.release(acquirePermits);
                }
                return value;
            })).get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (PrimitiveException.Interrupted | InterruptedException e) {
            needRelease.set(acquirePermits > 0);
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (PrimitiveException.Timeout | TimeoutException e) {
            needRelease.set(acquirePermits > 0);
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            needRelease.set(acquirePermits > 0);
            Throwable cause = Throwables.getRootCause((Throwable)e);
            if (cause instanceof PrimitiveException) {
                throw (PrimitiveException)cause;
            }
            throw new PrimitiveException(cause);
        }
    }

    private <T> T completeInterruptibly(CompletableFuture<T> future, int acquirePermits) throws InterruptedException {
        AtomicBoolean needRelease = new AtomicBoolean(false);
        try {
            return ((CompletableFuture)future.thenApply(value -> {
                if (needRelease.get() && acquirePermits > 0) {
                    this.asyncSemaphore.release(acquirePermits);
                }
                return value;
            })).get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (PrimitiveException.Interrupted | InterruptedException e) {
            needRelease.set(acquirePermits > 0);
            throw e;
        }
        catch (PrimitiveException.Timeout | TimeoutException e) {
            needRelease.set(acquirePermits > 0);
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            needRelease.set(acquirePermits > 0);
            Throwable cause = Throwables.getRootCause((Throwable)e);
            if (cause instanceof PrimitiveException) {
                throw (PrimitiveException)cause;
            }
            throw new PrimitiveException(cause);
        }
    }
}

