/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.set.impl;

import com.google.common.base.Preconditions;
import io.atomix.core.collection.CollectionEventListener;
import io.atomix.core.collection.impl.DistributedCollectionProxy;
import io.atomix.core.iterator.AsyncIterator;
import io.atomix.core.iterator.impl.IterableService;
import io.atomix.core.iterator.impl.ProxyIterator;
import io.atomix.core.set.AsyncDistributedNavigableSet;
import io.atomix.core.set.AsyncDistributedSortedSet;
import io.atomix.core.set.DistributedNavigableSet;
import io.atomix.core.set.impl.BlockingDistributedNavigableSet;
import io.atomix.core.set.impl.DescendingAsyncDistributedNavigableSet;
import io.atomix.core.set.impl.DistributedTreeSetService;
import io.atomix.core.set.impl.SetUpdate;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionLog;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.utils.concurrent.Futures;
import java.time.Duration;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public class DistributedNavigableSetProxy<E extends Comparable<E>>
extends DistributedCollectionProxy<AsyncDistributedNavigableSet<E>, DistributedTreeSetService<E>, E>
implements AsyncDistributedNavigableSet<E> {
    public DistributedNavigableSetProxy(ProxyClient<DistributedTreeSetService<E>> client, PrimitiveRegistry registry) {
        super(client, registry);
    }

    @Override
    public CompletableFuture<E> lower(E e) {
        return this.getProxyClient().applyBy(this.name(), service -> service.lower(e));
    }

    @Override
    public CompletableFuture<E> floor(E e) {
        return this.getProxyClient().applyBy(this.name(), service -> service.floor(e));
    }

    @Override
    public CompletableFuture<E> ceiling(E e) {
        return this.getProxyClient().applyBy(this.name(), service -> service.ceiling(e));
    }

    @Override
    public CompletableFuture<E> higher(E e) {
        return this.getProxyClient().applyBy(this.name(), service -> service.higher(e));
    }

    @Override
    public CompletableFuture<E> pollFirst() {
        return this.getProxyClient().applyBy(this.name(), service -> service.pollFirst());
    }

    @Override
    public CompletableFuture<E> pollLast() {
        return this.getProxyClient().applyBy(this.name(), service -> service.pollLast());
    }

    @Override
    public AsyncDistributedNavigableSet<E> descendingSet() {
        return new DescendingAsyncDistributedNavigableSet(this);
    }

    @Override
    public AsyncIterator<E> descendingIterator() {
        return new ProxyIterator(this.getProxyClient(), this.getProxyClient().getPartitionId(this.name()), DistributedTreeSetService::iterateDescending, IterableService::next, IterableService::close);
    }

    @Override
    public AsyncDistributedNavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new SubSet(this, fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public AsyncDistributedNavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new SubSet(this, null, false, toElement, inclusive);
    }

    @Override
    public AsyncDistributedNavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new SubSet(this, fromElement, inclusive, null, false);
    }

    @Override
    public AsyncDistributedSortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public AsyncDistributedSortedSet<E> headSet(E toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public AsyncDistributedSortedSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, true);
    }

    @Override
    public CompletableFuture<E> first() {
        return this.getProxyClient().applyBy(this.name(), service -> service.first()).thenCompose(value -> value != null ? CompletableFuture.completedFuture(value) : Futures.exceptionalFuture((Throwable)new NoSuchElementException()));
    }

    @Override
    public CompletableFuture<E> last() {
        return this.getProxyClient().applyBy(this.name(), service -> service.last()).thenCompose(value -> value != null ? CompletableFuture.completedFuture(value) : Futures.exceptionalFuture((Throwable)new NoSuchElementException()));
    }

    @Override
    public CompletableFuture<Boolean> prepare(TransactionLog<SetUpdate<E>> transactionLog) {
        return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
    }

    @Override
    public CompletableFuture<Void> commit(TransactionId transactionId) {
        return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
    }

    @Override
    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
    }

    @Override
    public DistributedNavigableSet<E> sync(Duration operationTimeout) {
        return new BlockingDistributedNavigableSet(this, operationTimeout.toMillis());
    }

    private class SubSet
    implements AsyncDistributedNavigableSet<E> {
        protected final E fromElement;
        protected final boolean fromInclusive;
        protected final E toElement;
        protected final boolean toInclusive;
        final /* synthetic */ DistributedNavigableSetProxy this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        SubSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            this.this$0 = (DistributedNavigableSetProxy)n;
            this.fromElement = fromElement;
            this.fromInclusive = fromInclusive;
            this.toElement = toElement;
            this.toInclusive = toInclusive;
        }

        public String name() {
            return this.this$0.name();
        }

        public PrimitiveType type() {
            return this.this$0.type();
        }

        public PrimitiveProtocol protocol() {
            return this.this$0.protocol();
        }

        private boolean isInBounds(E element) {
            if (element == null) {
                return false;
            }
            if (this.fromElement != null) {
                int lower = element.compareTo(this.fromElement);
                if (!this.fromInclusive && lower <= 0 || this.fromInclusive && lower < 0) {
                    return false;
                }
            }
            if (this.toElement != null) {
                int upper = element.compareTo(this.toElement);
                if (!this.toInclusive && upper >= 0 || this.toInclusive && upper > 0) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public CompletableFuture<E> pollFirst() {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<E> pollLast() {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<E> first() {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subSetFirst(this.fromElement, this.fromInclusive, this.toElement, this.toInclusive)).thenCompose(result -> result != null ? Futures.completedFuture((Object)result) : Futures.exceptionalFuture((Throwable)new NoSuchElementException()));
        }

        @Override
        public CompletableFuture<E> last() {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subSetLast(this.fromElement, this.fromInclusive, this.toElement, this.toInclusive)).thenCompose(result -> result != null ? Futures.completedFuture((Object)result) : Futures.exceptionalFuture((Throwable)new NoSuchElementException()));
        }

        @Override
        public CompletableFuture<E> lower(E e) {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subSetLower(e, this.fromElement, this.fromInclusive, this.toElement, this.toInclusive));
        }

        @Override
        public CompletableFuture<E> floor(E e) {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subSetFloor(e, this.fromElement, this.fromInclusive, this.toElement, this.toInclusive));
        }

        @Override
        public CompletableFuture<E> ceiling(E e) {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subSetCeiling(e, this.fromElement, this.fromInclusive, this.toElement, this.toInclusive));
        }

        @Override
        public CompletableFuture<E> higher(E e) {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subSetHigher(e, this.fromElement, this.fromInclusive, this.toElement, this.toInclusive));
        }

        @Override
        public AsyncDistributedNavigableSet<E> descendingSet() {
            return new DescendingAsyncDistributedNavigableSet(this);
        }

        @Override
        public AsyncDistributedSortedSet<E> subSet(E fromElement, E toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        @Override
        public AsyncDistributedSortedSet<E> headSet(E toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public AsyncDistributedSortedSet<E> tailSet(E fromElement) {
            return this.tailSet(fromElement, true);
        }

        @Override
        public AsyncDistributedNavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            int order;
            Preconditions.checkNotNull(fromElement);
            Preconditions.checkNotNull(toElement);
            if (this.fromElement != null) {
                order = this.fromElement.compareTo(fromElement);
                if (order == 0) {
                    fromInclusive = this.fromInclusive && fromInclusive;
                } else if (order > 0) {
                    fromElement = this.fromElement;
                    fromInclusive = this.fromInclusive;
                }
            }
            if (this.toElement != null) {
                order = this.toElement.compareTo(toElement);
                if (order == 0) {
                    toInclusive = this.toInclusive && toInclusive;
                } else if (order < 0) {
                    toElement = this.toElement;
                    toInclusive = this.toInclusive;
                }
            }
            return this.this$0.subSet(fromElement, fromInclusive, toElement, toInclusive);
        }

        @Override
        public AsyncDistributedNavigableSet<E> headSet(E toElement, boolean inclusive) {
            Preconditions.checkNotNull(toElement);
            if (this.toElement != null) {
                int order = this.toElement.compareTo(toElement);
                if (order == 0) {
                    inclusive = this.toInclusive && inclusive;
                } else if (order < 0) {
                    toElement = this.toElement;
                    inclusive = this.toInclusive;
                }
            }
            return this.this$0.subSet(this.fromElement, this.fromInclusive, toElement, inclusive);
        }

        @Override
        public AsyncDistributedNavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            Preconditions.checkNotNull(fromElement);
            if (this.fromElement != null) {
                int order = this.fromElement.compareTo(fromElement);
                if (order == 0) {
                    inclusive = this.fromInclusive && inclusive;
                } else if (order > 0) {
                    fromElement = this.fromElement;
                    inclusive = this.fromInclusive;
                }
            }
            return this.this$0.subSet(fromElement, inclusive, this.toElement, this.toInclusive);
        }

        @Override
        public CompletableFuture<Boolean> add(E element) {
            return this.isInBounds(element) ? this.this$0.add(element) : Futures.completedFuture((Object)false);
        }

        @Override
        public CompletableFuture<Boolean> remove(E element) {
            return this.isInBounds(element) ? this.this$0.remove(element) : Futures.completedFuture((Object)false);
        }

        @Override
        public CompletableFuture<Integer> size() {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subSetSize(this.fromElement, this.fromInclusive, this.toElement, this.toInclusive));
        }

        @Override
        public CompletableFuture<Boolean> isEmpty() {
            return this.size().thenApply(size -> size == 0);
        }

        @Override
        public CompletableFuture<Void> clear() {
            return this.this$0.getProxyClient().acceptBy(this.name(), service -> service.subSetClear(this.fromElement, this.fromInclusive, this.toElement, this.toInclusive));
        }

        @Override
        public CompletableFuture<Boolean> contains(E element) {
            return this.isInBounds(element) ? this.this$0.contains(element) : CompletableFuture.completedFuture(false);
        }

        @Override
        public CompletableFuture<Boolean> addAll(Collection<? extends E> c) {
            return this.this$0.addAll(c.stream().filter(this::isInBounds).collect(Collectors.toList()));
        }

        @Override
        public CompletableFuture<Boolean> containsAll(Collection<? extends E> c) {
            if (c.stream().map(this::isInBounds).reduce(Boolean::logicalAnd).orElse(true).booleanValue()) {
                return this.this$0.containsAll(c);
            }
            return CompletableFuture.completedFuture(false);
        }

        @Override
        public CompletableFuture<Boolean> retainAll(Collection<? extends E> c) {
            return this.this$0.retainAll(c.stream().filter(this::isInBounds).collect(Collectors.toList()));
        }

        @Override
        public CompletableFuture<Boolean> removeAll(Collection<? extends E> c) {
            return this.this$0.removeAll(c.stream().filter(this::isInBounds).collect(Collectors.toList()));
        }

        @Override
        public CompletableFuture<Void> addListener(CollectionEventListener<E> listener, Executor executor) {
            return this.this$0.addListener(listener, executor);
        }

        @Override
        public CompletableFuture<Void> removeListener(CollectionEventListener<E> listener) {
            return this.this$0.removeListener(listener);
        }

        @Override
        public AsyncIterator<E> iterator() {
            return new ProxyIterator(this.this$0.getProxyClient(), this.this$0.getProxyClient().getPartitionId(this.name()), service -> service.subSetIterate(this.fromElement, this.fromInclusive, this.toElement, this.toInclusive), IterableService::next, IterableService::close);
        }

        @Override
        public AsyncIterator<E> descendingIterator() {
            return new ProxyIterator(this.this$0.getProxyClient(), this.this$0.getProxyClient().getPartitionId(this.name()), service -> service.subSetIterateDescending(this.fromElement, this.fromInclusive, this.toElement, this.toInclusive), IterableService::next, IterableService::close);
        }

        @Override
        public CompletableFuture<Boolean> prepare(TransactionLog<SetUpdate<E>> transactionLog) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Void> commit(TransactionId transactionId) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Void> rollback(TransactionId transactionId) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        public CompletableFuture<Void> close() {
            return this.this$0.close();
        }

        public CompletableFuture<Void> delete() {
            return this.this$0.delete();
        }

        @Override
        public DistributedNavigableSet<E> sync(Duration operationTimeout) {
            return new BlockingDistributedNavigableSet(this, operationTimeout.toMillis());
        }
    }
}

