/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.time;

import com.google.common.base.MoreObjects;
import io.atomix.utils.time.Clock;
import io.atomix.utils.time.LogicalTimestamp;

public class LogicalClock
implements Clock<LogicalTimestamp> {
    private LogicalTimestamp currentTimestamp;

    public LogicalClock() {
        this(new LogicalTimestamp(0L));
    }

    public LogicalClock(LogicalTimestamp currentTimestamp) {
        this.currentTimestamp = currentTimestamp;
    }

    @Override
    public LogicalTimestamp getTime() {
        return this.currentTimestamp;
    }

    public LogicalTimestamp increment() {
        return this.update(new LogicalTimestamp(this.currentTimestamp.value() + 1L));
    }

    public LogicalTimestamp update(LogicalTimestamp timestamp) {
        if (timestamp.value() > this.currentTimestamp.value()) {
            this.currentTimestamp = timestamp;
        }
        return this.currentTimestamp;
    }

    public LogicalTimestamp incrementAndUpdate(LogicalTimestamp timestamp) {
        long nextValue = this.currentTimestamp.value() + 1L;
        if (timestamp.value() > nextValue) {
            return this.update(timestamp);
        }
        return this.increment();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("time", (Object)this.getTime()).toString();
    }
}

