/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.phi;

import com.google.common.base.Preconditions;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class PhiAccrualFailureDetector {
    private static final int DEFAULT_WINDOW_SIZE = 250;
    private static final int DEFAULT_MIN_SAMPLES = 25;
    private static final double DEFAULT_PHI_FACTOR = 1.0 / Math.log(10.0);
    private final int minSamples;
    private final double phiFactor;
    private final History history;

    public static Builder newBuilder() {
        return new Builder();
    }

    public PhiAccrualFailureDetector() {
        this(25, DEFAULT_PHI_FACTOR, 250);
    }

    public PhiAccrualFailureDetector(int minSamples, double phiFactor) {
        this(minSamples, phiFactor, 250);
    }

    public PhiAccrualFailureDetector(int minSamples, double phiFactor, int windowSize) {
        this.minSamples = minSamples;
        this.phiFactor = phiFactor;
        this.history = new History(windowSize);
    }

    public void report() {
        this.report(System.currentTimeMillis());
    }

    public void report(long arrivalTime) {
        Preconditions.checkArgument((arrivalTime >= 0L ? 1 : 0) != 0, (Object)"arrivalTime must not be negative");
        long latestHeartbeat = this.history.latestHeartbeatTime();
        if (latestHeartbeat != -1L) {
            this.history.samples().addValue((double)(arrivalTime - latestHeartbeat));
        }
        this.history.setLatestHeartbeatTime(arrivalTime);
    }

    public double phi() {
        long latestHeartbeat = this.history.latestHeartbeatTime();
        DescriptiveStatistics samples = this.history.samples();
        if (latestHeartbeat == -1L || samples.getN() < (long)this.minSamples) {
            return 0.0;
        }
        return this.computePhi(samples, latestHeartbeat, System.currentTimeMillis());
    }

    private double computePhi(DescriptiveStatistics samples, long lastHeartbeat, long currentTime) {
        long size = samples.getN();
        long t = currentTime - lastHeartbeat;
        return size > 0L ? this.phiFactor * (double)t / samples.getMean() : 100.0;
    }

    static /* synthetic */ double access$100() {
        return DEFAULT_PHI_FACTOR;
    }

    public static class Builder
    implements io.atomix.utils.Builder<PhiAccrualFailureDetector> {
        private int minSamples = 25;
        private double phiFactor = PhiAccrualFailureDetector.access$100();
        private int windowSize = 250;

        public Builder withMinSamples(int minSamples) {
            Preconditions.checkArgument((minSamples > 0 ? 1 : 0) != 0, (Object)"minSamples must be positive");
            this.minSamples = minSamples;
            return this;
        }

        public Builder withPhiFactor(double phiFactor) {
            this.phiFactor = phiFactor;
            return this;
        }

        public Builder withWindowSize(int windowSize) {
            Preconditions.checkArgument((windowSize > 0 ? 1 : 0) != 0, (Object)"windowSize must be positive");
            this.windowSize = windowSize;
            return this;
        }

        public PhiAccrualFailureDetector build() {
            return new PhiAccrualFailureDetector(this.minSamples, this.phiFactor, this.windowSize);
        }
    }

    private static class History {
        private final DescriptiveStatistics samples;
        long lastHeartbeatTime = -1L;

        private History(int windowSize) {
            this.samples = new DescriptiveStatistics(windowSize);
        }

        DescriptiveStatistics samples() {
            return this.samples;
        }

        long latestHeartbeatTime() {
            return this.lastHeartbeatTime;
        }

        void setLatestHeartbeatTime(long value) {
            this.lastHeartbeatTime = value;
        }
    }
}

