/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.serializer.Serializer;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.HeapBuffer;
import io.atomix.storage.journal.Indexed;
import io.atomix.storage.journal.JournalReader;
import io.atomix.storage.journal.JournalSegmentDescriptor;
import java.nio.BufferUnderflowException;
import java.util.NoSuchElementException;
import java.util.zip.CRC32;

public class JournalSegmentReader<E>
implements JournalReader<E> {
    private final Buffer buffer;
    private final Serializer serializer;
    private final HeapBuffer memory = HeapBuffer.allocate();
    private final long firstIndex;
    private Indexed<E> currentEntry;
    private Indexed<E> nextEntry;

    public JournalSegmentReader(JournalSegmentDescriptor descriptor, Serializer serializer) {
        this.buffer = descriptor.buffer().slice().duplicate();
        this.serializer = serializer;
        this.firstIndex = descriptor.index();
        this.readNext();
    }

    @Override
    public long getCurrentIndex() {
        return this.currentEntry != null ? this.currentEntry.index() : 0L;
    }

    @Override
    public Indexed<E> getCurrentEntry() {
        return this.currentEntry;
    }

    @Override
    public long getNextIndex() {
        return this.currentEntry != null ? this.currentEntry.index() + 1L : this.firstIndex;
    }

    @Override
    public void reset(long index) {
        this.reset();
        while (this.getNextIndex() < index && this.hasNext()) {
            this.next();
        }
    }

    @Override
    public void reset() {
        this.buffer.clear();
        this.currentEntry = null;
        this.nextEntry = null;
        this.readNext();
    }

    @Override
    public boolean hasNext() {
        if (this.nextEntry == null) {
            this.readNext();
        }
        return this.nextEntry != null;
    }

    @Override
    public Indexed<E> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentEntry = this.nextEntry;
        this.nextEntry = null;
        this.readNext();
        return this.currentEntry;
    }

    private void readNext() {
        long index = this.getNextIndex();
        this.buffer.mark();
        try {
            int length = this.buffer.readInt();
            if (length == 0) {
                this.buffer.reset();
                this.nextEntry = null;
                return;
            }
            long checksum = this.buffer.readUnsignedInt();
            this.buffer.read(this.memory.clear().limit(length));
            this.memory.flip();
            CRC32 crc32 = new CRC32();
            crc32.update(this.memory.array(), 0, length);
            if (checksum == crc32.getValue()) {
                Object entry = this.serializer.decode(this.memory.array());
                this.nextEntry = new Indexed<Object>(index, entry, length);
            } else {
                this.buffer.reset();
                this.nextEntry = null;
            }
        }
        catch (BufferUnderflowException e) {
            this.buffer.reset();
            this.nextEntry = null;
        }
    }

    @Override
    public void close() {
        this.memory.close();
        this.buffer.close();
    }
}

