/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.serializer.Serializer;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.FileBuffer;
import io.atomix.storage.buffer.HeapBuffer;
import io.atomix.storage.buffer.MappedBuffer;
import io.atomix.storage.buffer.SlicedBuffer;
import io.atomix.storage.journal.Indexed;
import io.atomix.storage.journal.JournalSegmentDescriptor;
import io.atomix.storage.journal.JournalWriter;
import java.util.zip.CRC32;

public class JournalSegmentWriter<E>
implements JournalWriter<E> {
    private final JournalSegmentDescriptor descriptor;
    private final Buffer buffer;
    private final Serializer serializer;
    private final HeapBuffer memory = HeapBuffer.allocate();
    private final long firstIndex;
    private Indexed<E> lastEntry;

    public JournalSegmentWriter(JournalSegmentDescriptor descriptor, Serializer serializer) {
        this.descriptor = descriptor;
        this.buffer = descriptor.buffer().slice();
        this.serializer = serializer;
        this.firstIndex = descriptor.index();
        this.reset(0L);
    }

    private void reset(long index) {
        this.buffer.clear();
        int length = this.buffer.mark().readInt();
        for (long nextIndex = this.firstIndex; length > 0 && (index == 0L || nextIndex <= index); ++nextIndex) {
            long checksum = this.buffer.readUnsignedInt();
            this.buffer.read(this.memory.clear().limit(length));
            this.memory.flip();
            CRC32 crc32 = new CRC32();
            crc32.update(this.memory.array(), 0, length);
            if (checksum != crc32.getValue()) break;
            Object entry = this.serializer.decode(this.memory.array());
            this.lastEntry = new Indexed<Object>(nextIndex, entry, length);
            length = this.buffer.mark().readInt();
        }
        this.buffer.reset();
    }

    @Override
    public long getLastIndex() {
        return this.lastEntry != null ? this.lastEntry.index() : this.descriptor.index() - 1L;
    }

    @Override
    public Indexed<E> getLastEntry() {
        return this.lastEntry;
    }

    @Override
    public long getNextIndex() {
        if (this.lastEntry != null) {
            return this.lastEntry.index() + 1L;
        }
        return this.firstIndex;
    }

    public long size() {
        return this.buffer.offset() + this.buffer.position();
    }

    public boolean isEmpty() {
        return this.lastEntry == null;
    }

    public boolean isFull() {
        return this.size() >= (long)this.descriptor.maxSegmentSize() || this.getNextIndex() - this.firstIndex >= (long)this.descriptor.maxEntries();
    }

    public long firstIndex() {
        return this.firstIndex;
    }

    @Override
    public void append(Indexed<E> entry) {
        long nextIndex = this.getNextIndex();
        if (entry.index() > nextIndex) {
            throw new IndexOutOfBoundsException("Entry index is not sequential");
        }
        if (entry.index() < nextIndex) {
            this.truncate(entry.index() - 1L);
        }
        this.append(entry.entry());
    }

    @Override
    public <T extends E> Indexed<T> append(T entry) {
        long index = this.getNextIndex();
        byte[] bytes = this.serializer.encode(entry);
        int length = bytes.length;
        CRC32 crc32 = new CRC32();
        crc32.update(bytes, 0, length);
        long checksum = crc32.getValue();
        this.buffer.writeInt(length).writeUnsignedInt(checksum).write(bytes);
        Indexed<T> indexedEntry = new Indexed<T>(index, entry, length);
        this.lastEntry = indexedEntry;
        return indexedEntry;
    }

    @Override
    public void truncate(long index) {
        if (index >= this.getLastIndex()) {
            return;
        }
        this.lastEntry = null;
        if (index < this.descriptor.index()) {
            ((Buffer)this.buffer.zero()).clear();
            return;
        }
        this.reset(index);
        this.buffer.zero(this.buffer.position());
    }

    @Override
    public void flush() {
        this.buffer.flush();
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    void delete() {
        Buffer buffer;
        Buffer buffer2 = buffer = this.buffer instanceof SlicedBuffer ? ((SlicedBuffer)this.buffer).root() : this.buffer;
        if (buffer instanceof FileBuffer) {
            ((FileBuffer)buffer).delete();
        } else if (buffer instanceof MappedBuffer) {
            ((MappedBuffer)buffer).delete();
        }
    }
}

