/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.partition;

import com.google.common.base.MoreObjects;
import io.atomix.cluster.NodeId;
import io.atomix.primitive.PrimitiveClient;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.partition.PrimaryTerm;
import io.atomix.protocols.backup.MultiPrimaryProtocol;
import io.atomix.protocols.backup.partition.impl.PrimaryBackupPartitionClient;
import io.atomix.protocols.backup.partition.impl.PrimaryBackupPartitionServer;
import io.atomix.utils.concurrent.ThreadContextFactory;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

public class PrimaryBackupPartition
implements Partition<MultiPrimaryProtocol> {
    private final PartitionId partitionId;
    private PrimaryElection election;
    private PrimaryBackupPartitionServer server;
    private PrimaryBackupPartitionClient client;

    public PrimaryBackupPartition(PartitionId partitionId) {
        this.partitionId = partitionId;
    }

    public PartitionId id() {
        return this.partitionId;
    }

    public long term() {
        return ((PrimaryTerm)this.election.getTerm().join()).term();
    }

    public NodeId primary() {
        return ((PrimaryTerm)this.election.getTerm().join()).primary();
    }

    public Collection<NodeId> backups() {
        return ((PrimaryTerm)this.election.getTerm().join()).backups();
    }

    public String name() {
        return String.format("%s-partition-%d", this.partitionId.group(), this.partitionId.id());
    }

    public PrimitiveClient<MultiPrimaryProtocol> getPrimitiveClient() {
        return this.client;
    }

    CompletableFuture<Partition> open(PartitionManagementService managementService, ThreadContextFactory threadFactory) {
        this.election = managementService.getElectionService().getElectionFor(this.partitionId);
        this.server = new PrimaryBackupPartitionServer(this, managementService, threadFactory);
        this.client = new PrimaryBackupPartitionClient(this, managementService, threadFactory);
        return ((CompletableFuture)this.server.start().thenCompose(v -> this.client.start())).thenApply(v -> this);
    }

    public CompletableFuture<Void> close() {
        if (this.client == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.client.stop().whenComplete((clientResult, clientError) -> this.server.stop().whenComplete((serverResult, serverError) -> future.complete(null)));
        return future;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.partitionId).toString();
    }
}

