/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.primitive.DistributedPrimitive;
import io.atomix.primitive.proxy.PrimitiveProxy;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractAsyncPrimitive
implements AsyncPrimitive {
    private final Function<PrimitiveProxy.State, DistributedPrimitive.Status> mapper = state -> {
        switch (state) {
            case CONNECTED: {
                return DistributedPrimitive.Status.ACTIVE;
            }
            case SUSPENDED: {
                return DistributedPrimitive.Status.SUSPENDED;
            }
            case CLOSED: {
                return DistributedPrimitive.Status.INACTIVE;
            }
        }
        throw new IllegalStateException("Unknown state " + (Object)state);
    };
    protected final PrimitiveProxy proxy;
    private final Set<Consumer<DistributedPrimitive.Status>> statusChangeListeners = Sets.newCopyOnWriteArraySet();

    public AbstractAsyncPrimitive(PrimitiveProxy proxy) {
        this.proxy = (PrimitiveProxy)Preconditions.checkNotNull((Object)proxy, (Object)"proxy cannot be null");
        proxy.addStateChangeListener(this::onStateChange);
    }

    @Override
    public String name() {
        return this.proxy.name();
    }

    private void onStateChange(PrimitiveProxy.State state) {
        this.statusChangeListeners.forEach(listener -> listener.accept(this.mapper.apply(state)));
    }

    @Override
    public void addStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.statusChangeListeners.add(listener);
    }

    @Override
    public void removeStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.statusChangeListeners.remove(listener);
    }

    @Override
    public Collection<Consumer<DistributedPrimitive.Status>> statusChangeListeners() {
        return ImmutableSet.copyOf(this.statusChangeListeners);
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.proxy.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("proxy", (Object)this.proxy).toString();
    }
}

