/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition;

import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.primitive.partition.PartitionGroupFactory;
import io.atomix.utils.ConfigurationException;
import io.atomix.utils.Services;

public class PartitionGroups {
    private static final String RAFT = "raft";
    private static final String PRIMARY_BACKUP = "multi-primary";

    public static ManagedPartitionGroup createGroup(PartitionGroupConfig config) {
        for (PartitionGroupFactory factory : Services.loadAll(PartitionGroupFactory.class)) {
            if (!factory.configClass().isAssignableFrom(config.getClass())) continue;
            return factory.createGroup(config);
        }
        throw new ConfigurationException("Unknown partition group configuration type: " + config.getClass().getSimpleName());
    }

    public static PartitionGroupFactory getGroupFactory(String type) {
        for (PartitionGroupFactory factory : Services.loadAll(PartitionGroupFactory.class)) {
            if (!factory.type().name().equals(type)) continue;
            return factory;
        }
        throw new ConfigurationException("Unknown partition group type: " + type);
    }

    public static PartitionGroupFactory getRaftGroupFactory() {
        return PartitionGroups.getGroupFactory(RAFT);
    }

    public static PartitionGroupFactory getPrimaryBackupGroupFactory() {
        return PartitionGroups.getGroupFactory(PRIMARY_BACKUP);
    }

    private PartitionGroups() {
    }
}

