/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition.impl;

import com.google.common.hash.Hashing;
import io.atomix.cluster.ClusterEventListener;
import io.atomix.cluster.ClusterService;
import io.atomix.cluster.Node;
import io.atomix.primitive.partition.Member;
import io.atomix.primitive.partition.MemberGroupId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.partition.PrimaryElectionEvent;
import io.atomix.primitive.partition.PrimaryElectionEventListener;
import io.atomix.primitive.partition.PrimaryTerm;
import io.atomix.primitive.partition.impl.HashBasedPrimaryElectionService;
import io.atomix.utils.event.AbstractListenerManager;
import io.atomix.utils.event.Event;
import io.atomix.utils.event.EventListener;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;

public class HashBasedPrimaryElection
extends AbstractListenerManager<PrimaryElectionEvent, PrimaryElectionEventListener>
implements PrimaryElection {
    private final PartitionId partitionId;
    private final ClusterService clusterService;
    private final HashBasedPrimaryElectionService electionService;
    private final ClusterEventListener clusterEventListener = e -> this.recomputeTerm();
    private volatile PrimaryTerm currentTerm;

    public HashBasedPrimaryElection(PartitionId partitionId, ClusterService clusterService, HashBasedPrimaryElectionService electionService) {
        this.partitionId = partitionId;
        this.clusterService = clusterService;
        this.electionService = electionService;
        this.recomputeTerm();
        clusterService.addListener((EventListener)this.clusterEventListener);
    }

    @Override
    public CompletableFuture<PrimaryTerm> enter(Member member) {
        return CompletableFuture.completedFuture(this.currentTerm);
    }

    @Override
    public CompletableFuture<PrimaryTerm> getTerm() {
        return CompletableFuture.completedFuture(this.currentTerm);
    }

    private void recomputeTerm() {
        ArrayList<Member> candidates = new ArrayList<Member>();
        for (Node node : this.clusterService.getNodes()) {
            if (node.getState() != Node.State.ACTIVE) continue;
            candidates.add(new Member(node.id(), MemberGroupId.from((String)((Object)node.id().id()))));
        }
        candidates.sort((a, b) -> {
            int aoffset = Hashing.murmur3_32().hashString((CharSequence)((Object)a.nodeId().id()), StandardCharsets.UTF_8).asInt() % (Integer)this.partitionId.id();
            int boffset = Hashing.murmur3_32().hashString((CharSequence)((Object)b.nodeId().id()), StandardCharsets.UTF_8).asInt() % (Integer)this.partitionId.id();
            return aoffset - boffset;
        });
        this.currentTerm = new PrimaryTerm(this.electionService.incrementTerm(), (Member)candidates.get(0), candidates.subList(1, candidates.size()));
        this.post((Event)new PrimaryElectionEvent(PrimaryElectionEvent.Type.CHANGED, this.partitionId, this.currentTerm));
    }
}

