/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.manager.internal;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.copycat.server.session.Sessions;
import io.atomix.manager.internal.ManagedResourceSession;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ResourceManagerSessions
implements Sessions,
AutoCloseable {
    private ManagedResourceSession first;
    private final Map<Long, ManagedResourceSession> sessions = new HashMap<Long, ManagedResourceSession>();
    private final Set<SessionListener> listeners = new HashSet<SessionListener>();

    public ManagedResourceSession session(long sessionId) {
        return this.sessions.get(sessionId);
    }

    void register(ManagedResourceSession session) {
        if (this.first == null) {
            this.first = session;
        }
        if (this.sessions.containsKey(session.id())) {
            session.commit.close();
        } else {
            this.sessions.put(session.id(), session);
            for (SessionListener listener : this.listeners) {
                listener.register((ServerSession)session);
            }
        }
    }

    void unregister(long sessionId) {
        ManagedResourceSession session = this.sessions.get(sessionId);
        if (session != null) {
            for (SessionListener listener : this.listeners) {
                listener.unregister((ServerSession)session);
            }
        }
    }

    void expire(long sessionId) {
        ManagedResourceSession session = this.sessions.get(sessionId);
        if (session != null) {
            for (SessionListener listener : this.listeners) {
                listener.expire((ServerSession)session);
            }
        }
    }

    void close(long sessionId) {
        ManagedResourceSession session = this.sessions.remove(sessionId);
        if (session != null) {
            for (SessionListener listener : this.listeners) {
                listener.close((ServerSession)session);
            }
            if (session.commit != this.first.commit) {
                session.commit.close();
            }
        }
    }

    public Sessions addListener(SessionListener listener) {
        this.listeners.add((SessionListener)Assert.notNull((Object)listener, (String)"listener"));
        return this;
    }

    public Sessions removeListener(SessionListener listener) {
        this.listeners.remove(Assert.notNull((Object)listener, (String)"listener"));
        return this;
    }

    public Iterator<ServerSession> iterator() {
        return this.sessions.values().iterator();
    }

    @Override
    public void close() {
        for (ManagedResourceSession session : this.sessions.values()) {
            session.commit.close();
        }
    }
}

