/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.impl;

import io.atomix.rest.impl.EventLog;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class EventManager {
    private final Map<Class<?>, Map<String, EventLog>> eventRegistries = new ConcurrentHashMap();

    public <L, E> EventLog<L, E> getEventLog(Class<?> type, String name) {
        return (EventLog)this.eventRegistries.computeIfAbsent(type, t -> new ConcurrentHashMap()).get(name);
    }

    public <L, E> EventLog<L, E> getOrCreateEventLog(Class<?> type, String name, Function<EventLog<L, E>, L> listenerFactory) {
        return this.eventRegistries.computeIfAbsent(type, t -> new ConcurrentHashMap()).computeIfAbsent(name, n -> new EventLog(listenerFactory));
    }

    public <L, E> EventLog<L, E> removeEventLog(Class<?> type, String name) {
        return (EventLog)this.eventRegistries.computeIfAbsent(type, t -> new ConcurrentHashMap()).remove(name);
    }

    public Set<String> getEventLogNames(Class<?> type) {
        return this.eventRegistries.computeIfAbsent(type, t -> new ConcurrentHashMap()).keySet();
    }
}

