/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.testing;

import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.transport.local.LocalServerRegistry;
import io.atomix.catalyst.transport.local.LocalTransport;
import io.atomix.copycat.client.ConnectionStrategies;
import io.atomix.copycat.client.ConnectionStrategy;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.copycat.client.RecoveryStrategies;
import io.atomix.copycat.client.RecoveryStrategy;
import io.atomix.copycat.client.ServerSelectionStrategies;
import io.atomix.copycat.client.ServerSelectionStrategy;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.StateMachine;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.copycat.server.storage.StorageLevel;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceFactory;
import io.atomix.resource.ResourceType;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import net.jodah.concurrentunit.ConcurrentTestCase;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class AbstractCopycatTest<T extends Resource>
extends ConcurrentTestCase {
    protected LocalServerRegistry registry;
    protected int port;
    protected List<Address> members;
    protected List<T> resources;
    protected List<CopycatServer> servers;

    protected abstract Class<? super T> type();

    @BeforeMethod
    protected void init() {
        this.port = 5000;
        this.registry = new LocalServerRegistry();
        this.members = new ArrayList<Address>();
        this.resources = new ArrayList<T>();
        this.servers = new ArrayList<CopycatServer>();
    }

    @AfterMethod
    protected void cleanup() {
        this.resources.stream().forEach(c -> {
            try {
                c.close().join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.servers.stream().forEach(s -> {
            try {
                s.leave().join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.resources.clear();
        this.servers.clear();
    }

    private Address nextAddress() {
        return new Address("localhost", this.port++);
    }

    protected CopycatClient createCopycatClient() {
        return CopycatClient.builder(this.members).withTransport((Transport)new LocalTransport(this.registry)).withServerSelectionStrategy((ServerSelectionStrategy)ServerSelectionStrategies.ANY).withConnectionStrategy((ConnectionStrategy)ConnectionStrategies.FIBONACCI_BACKOFF).withRecoveryStrategy((RecoveryStrategy)RecoveryStrategies.RECOVER).build();
    }

    protected T createResource() throws Throwable {
        return this.createResource(new Resource.Options());
    }

    protected T createResource(Resource.Config config) throws Throwable {
        return this.createResource(this.createCopycatClient(), new Resource.Options());
    }

    protected T createResource(Resource.Options options) throws Throwable {
        return this.createResource(this.createCopycatClient(), options);
    }

    protected T createResource(CopycatClient client, Resource.Options options) throws Throwable {
        ResourceType type = new ResourceType(this.type());
        Resource resource = ((ResourceFactory)type.factory().newInstance()).createInstance(client, (Properties)options);
        ((ResourceFactory)type.factory().newInstance()).createSerializableTypeResolver().resolve(client.serializer().registry());
        resource.open().thenRun(() -> ((AbstractCopycatTest)this).resume());
        this.resources.add(resource);
        this.await(10000L);
        return (T)resource;
    }

    protected CopycatServer createServer(Address address) throws Throwable {
        return this.createServer(address, new Resource.Config());
    }

    protected CopycatServer createServer(Address address, Resource.Config config) throws Throwable {
        ResourceType type = new ResourceType(this.type());
        Supplier<StateMachine> stateMachine = () -> {
            try {
                return ((ResourceFactory)type.factory().newInstance()).createStateMachine((Properties)config);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        };
        CopycatServer server = CopycatServer.builder((Address)address).withTransport((Transport)new LocalTransport(this.registry)).withStorage(new Storage(StorageLevel.MEMORY)).withStateMachine(stateMachine).build();
        ((ResourceFactory)type.factory().newInstance()).createSerializableTypeResolver().resolve(server.serializer().registry());
        this.servers.add(server);
        return server;
    }

    protected List<CopycatServer> createServers(int live, int total) throws Throwable {
        return this.createServers(live, total, new Resource.Config());
    }

    protected List<CopycatServer> createServers(int live, int total, Resource.Config config) throws Throwable {
        ArrayList<Address> members = new ArrayList<Address>();
        for (int i = 0; i < total; ++i) {
            members.add(this.nextAddress());
        }
        this.members.addAll(members);
        ArrayList<CopycatServer> servers = new ArrayList<CopycatServer>();
        for (int i = 0; i < live; ++i) {
            CopycatServer server = this.createServer((Address)members.get(i), config);
            server.bootstrap(members).thenRun(() -> ((AbstractCopycatTest)this).resume());
            servers.add(server);
        }
        this.await(0L, live);
        return servers;
    }

    protected List<CopycatServer> createServers(int nodes) throws Throwable {
        return this.createServers(nodes, nodes, new Resource.Config());
    }

    protected List<CopycatServer> createServers(int nodes, Resource.Config config) throws Throwable {
        return this.createServers(nodes, nodes, config);
    }
}

