/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.testing;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.LoggerFactory;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;

public class TestCaseLogger
implements IInvokedMethodListener {
    private static final Map<ITestNGMethod, Long> START_TIMES = new ConcurrentHashMap<ITestNGMethod, Long>();

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        if (!method.isTestMethod()) {
            return;
        }
        ITestNGMethod testMethod = method.getTestMethod();
        ITestClass clazz = testMethod.getTestClass();
        START_TIMES.put(testMethod, System.currentTimeMillis());
        LoggerFactory.getLogger((String)"BEFORE").info("{}#{}", (Object)clazz.getRealClass().getName(), (Object)testMethod.getMethodName());
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        if (!method.isTestMethod()) {
            return;
        }
        ITestNGMethod testMethod = method.getTestMethod();
        ITestClass clazz = testMethod.getTestClass();
        double elapsed = (double)(System.currentTimeMillis() - START_TIMES.remove(testMethod)) / 1000.0;
        if (elapsed > 1.0) {
            LoggerFactory.getLogger((String)"AFTER").info("{}#{} Ran for {} seconds", new Object[]{clazz.getRealClass().getName(), testMethod.getMethodName(), elapsed});
        }
    }
}

