/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.memory;

import io.atomix.utils.memory.BufferCleaner;
import io.atomix.utils.memory.MappedMemoryAllocator;
import io.atomix.utils.memory.Memory;
import java.io.File;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedMemory
implements Memory {
    private static final long MAX_SIZE = 0x7FFFFFFAL;
    private static final Logger LOGGER = LoggerFactory.getLogger(MappedMemory.class);
    private final MappedByteBuffer buffer;
    private final MappedMemoryAllocator allocator;
    private final int size;

    public static MappedMemory allocate(File file, int size) {
        return new MappedMemoryAllocator(file).allocate(size);
    }

    public static MappedMemory allocate(File file, FileChannel.MapMode mode, int size) {
        if ((long)size > 0x7FFFFFFAL) {
            throw new IllegalArgumentException("size cannot be greater than 2147483642");
        }
        return new MappedMemoryAllocator(file, mode).allocate(size);
    }

    public MappedMemory(MappedByteBuffer buffer, MappedMemoryAllocator allocator) {
        this.buffer = buffer;
        this.allocator = allocator;
        this.size = buffer.capacity();
    }

    public void flush() {
        this.buffer.force();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void free() {
        block2: {
            try {
                BufferCleaner.freeBuffer(this.buffer);
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Failed to unmap direct buffer", (Throwable)e);
            }
        }
        this.allocator.release();
    }

    public void close() {
        this.free();
        this.allocator.close();
    }
}

