/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.persistence.db;

import io.automatiko.engine.addons.persistence.common.JacksonObjectMarshallingStrategy;
import io.automatiko.engine.addons.persistence.common.tlog.TransactionLogImpl;
import io.automatiko.engine.addons.persistence.db.model.ProcessInstanceEntity;
import io.automatiko.engine.api.Model;
import io.automatiko.engine.api.audit.AuditEntry;
import io.automatiko.engine.api.audit.Auditor;
import io.automatiko.engine.api.auth.AccessDeniedException;
import io.automatiko.engine.api.marshalling.ObjectMarshallingStrategy;
import io.automatiko.engine.api.runtime.process.WorkflowProcessInstance;
import io.automatiko.engine.api.uow.TransactionLog;
import io.automatiko.engine.api.uow.TransactionLogStore;
import io.automatiko.engine.api.workflow.ConflictingVersionException;
import io.automatiko.engine.api.workflow.ExportedProcessInstance;
import io.automatiko.engine.api.workflow.MutableProcessInstances;
import io.automatiko.engine.api.workflow.Process;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.api.workflow.ProcessInstanceDuplicatedException;
import io.automatiko.engine.api.workflow.ProcessInstanceReadMode;
import io.automatiko.engine.api.workflow.encrypt.StoredDataCodec;
import io.automatiko.engine.workflow.AbstractProcess;
import io.automatiko.engine.workflow.AbstractProcessInstance;
import io.automatiko.engine.workflow.audit.BaseAuditEntry;
import io.automatiko.engine.workflow.base.instance.context.variable.VariableScopeInstance;
import io.automatiko.engine.workflow.base.instance.impl.ProcessInstanceImpl;
import io.automatiko.engine.workflow.marshalling.ProcessInstanceMarshaller;
import io.quarkus.hibernate.orm.panache.runtime.JpaOperations;
import io.quarkus.hibernate.orm.panache.runtime.PanacheQueryImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.persistence.OptimisticLockException;
import org.hibernate.StaleObjectStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseProcessInstances
implements MutableProcessInstances<ProcessInstanceEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseProcessInstances.class);
    private final Process<? extends ProcessInstanceEntity> process;
    private final ProcessInstanceMarshaller marshaller;
    private final StoredDataCodec codec;
    private Class<? extends ProcessInstanceEntity> type;
    private TransactionLog transactionLog;
    private Auditor auditor;

    public DatabaseProcessInstances(Process<? extends ProcessInstanceEntity> process, StoredDataCodec codec, TransactionLogStore store, Auditor auditor) {
        this.process = process;
        this.marshaller = new ProcessInstanceMarshaller(new ObjectMarshallingStrategy[]{new JacksonObjectMarshallingStrategy(process)});
        this.codec = codec;
        this.auditor = auditor;
        this.type = ((Object)((Object)((ProcessInstanceEntity)((Object)process.createModel())))).getClass();
        this.marshaller.addToEnvironment("_ignore_vars_", (Object)true);
        this.transactionLog = new TransactionLogImpl(store, new ObjectMarshallingStrategy[]{new JacksonObjectMarshallingStrategy(process)});
    }

    public TransactionLog transactionLog() {
        return this.transactionLog;
    }

    public Optional<ProcessInstance<ProcessInstanceEntity>> findById(String id, int status, ProcessInstanceReadMode mode) {
        byte[] content;
        String resolvedId = this.resolveId(id);
        Optional found = JpaOperations.INSTANCE.findByIdOptional(this.type, (Object)resolvedId);
        if (status == -1 && (content = this.transactionLog.readContent(this.process.id(), resolvedId)) != null) {
            ProcessInstance pi;
            long versionTracker = 1L;
            ProcessInstanceEntity entity = null;
            if (found.isPresent()) {
                entity = (ProcessInstanceEntity)((Object)found.get());
                versionTracker = entity.version;
            }
            if (mode == ProcessInstanceReadMode.MUTABLE) {
                WorkflowProcessInstance wpi = this.marshaller.unmarshallWorkflowProcessInstance(content, this.process);
                if (entity == null) {
                    entity = (ProcessInstanceEntity)((Object)this.process.createModel());
                    entity.fromMap(wpi.getVariables());
                }
                pi = ((AbstractProcess)this.process).createInstance(wpi, (Model)entity, versionTracker);
            } else {
                WorkflowProcessInstance wpi = this.marshaller.unmarshallWorkflowProcessInstance(content, this.process);
                if (entity == null) {
                    entity = (ProcessInstanceEntity)((Object)this.process.createModel());
                    entity.fromMap(wpi.getVariables());
                }
                pi = ((AbstractProcess)this.process).createReadOnlyInstance(wpi, (Model)entity);
            }
            return Optional.of(this.audit((ProcessInstance<ProcessInstanceEntity>)pi));
        }
        if (found.isEmpty()) {
            return Optional.empty();
        }
        ProcessInstanceEntity entity = (ProcessInstanceEntity)((Object)found.get());
        if (entity.state == status) {
            return Optional.of(this.audit(this.unmarshallInstance(mode, entity)));
        }
        return Optional.empty();
    }

    public Collection<? extends ProcessInstance<ProcessInstanceEntity>> findByIdOrTag(ProcessInstanceReadMode mode, int status, String ... values) {
        return JpaOperations.INSTANCE.stream(this.type, "state = ?1 and (id in (?2) or (?2) in elements(tags)) ", new Object[]{status, Arrays.asList(values)}).map(e -> {
            try {
                return this.audit(this.unmarshallInstance(mode, (ProcessInstanceEntity)((Object)((Object)e))));
            }
            catch (AccessDeniedException ex) {
                return null;
            }
        }).filter(pi -> pi != null).collect(Collectors.toSet());
    }

    public Collection<String> locateByIdOrTag(int status, String ... values) {
        return JpaOperations.INSTANCE.stream(this.type, "state = ?1 and (id in (?2) or (?2) in elements(tags)) ", new Object[]{status, Arrays.asList(values)}).map(e -> ((ProcessInstanceEntity)((Object)((Object)e))).entityId).collect(Collectors.toSet());
    }

    public Collection<ProcessInstance<ProcessInstanceEntity>> values(ProcessInstanceReadMode mode, int status, int page, int size) {
        return ((PanacheQueryImpl)JpaOperations.INSTANCE.find(this.type, "state = ?1 ", new Object[]{status})).page(this.calculatePage(page, size), size).stream().map(e -> {
            try {
                return this.audit(this.unmarshallInstance(mode, (ProcessInstanceEntity)((Object)((Object)e))));
            }
            catch (AccessDeniedException ex) {
                return null;
            }
        }).filter(pi -> pi != null).collect(Collectors.toList());
    }

    public Long size() {
        return JpaOperations.INSTANCE.count(this.type);
    }

    public boolean exists(String id) {
        String resolvedId = this.resolveId(id);
        Optional found = JpaOperations.INSTANCE.findByIdOptional(this.type, (Object)resolvedId);
        return found.isPresent();
    }

    public void create(String id, ProcessInstance<ProcessInstanceEntity> instance) {
        this.store(id, instance);
        Supplier<AuditEntry> entry = () -> BaseAuditEntry.persitenceWrite((ProcessInstance)instance).add("message", (Object)"Workflow instance created in the rdbms based data store");
        this.auditor.publish(entry);
    }

    public void update(String id, ProcessInstance<ProcessInstanceEntity> instance) {
        this.store(id, instance);
        Supplier<AuditEntry> entry = () -> BaseAuditEntry.persitenceWrite((ProcessInstance)instance).add("message", (Object)"Workflow instance updated in the rdbms based data store");
        this.auditor.publish(entry);
    }

    public void remove(String id, ProcessInstance<ProcessInstanceEntity> instance) {
        ProcessInstanceEntity entity = (ProcessInstanceEntity)((Object)instance.variables());
        JpaOperations.INSTANCE.persist((Object)entity);
        JpaOperations.INSTANCE.deleteById(this.type, (Object)this.resolveId(id, instance));
        Supplier<AuditEntry> entry = () -> BaseAuditEntry.persitenceWrite((ProcessInstance)instance).add("message", (Object)"Workflow instance removed from the rdbms based data store");
        this.auditor.publish(entry);
    }

    protected void store(String id, ProcessInstance<ProcessInstanceEntity> instance) {
        String resolvedId = this.resolveId(id, instance);
        if (this.isActive(instance)) {
            ProcessInstanceEntity entity = (ProcessInstanceEntity)((Object)instance.variables());
            byte[] data = this.codec.encode(this.marshaller.marhsallProcessInstance(instance));
            if (data == null) {
                return;
            }
            entity.content = data;
            entity.entityId = resolvedId;
            entity.name = instance.description();
            entity.businessKey = instance.businessKey();
            entity.processId = instance.process().id();
            entity.processName = instance.process().name();
            entity.processVersion = instance.process().version();
            entity.startDate = instance.startDate();
            entity.endtDate = instance.endDate();
            entity.expiredAtDate = instance.expiresAtDate();
            entity.state = instance.status();
            entity.tags = new HashSet<String>(instance.tags().values());
            try {
                JpaOperations.INSTANCE.persist((Object)entity);
            }
            catch (OptimisticLockException | StaleObjectStateException e) {
                throw new ConflictingVersionException("Process instance with id '" + instance.id() + "' has older version than tha stored one");
            }
            finally {
                this.disconnect(instance);
            }
        }
    }

    protected void disconnect(ProcessInstance<ProcessInstanceEntity> instance) {
        ((AbstractProcessInstance)instance).internalRemoveProcessInstance(() -> {
            try {
                ProcessInstanceEntity entity = (ProcessInstanceEntity)((Object)((Object)JpaOperations.INSTANCE.findById(this.type, (Object)this.resolveId(instance.id(), instance))));
                byte[] reloaded = this.codec.decode(entity.content);
                WorkflowProcessInstance wpi = this.marshaller.unmarshallWorkflowProcessInstance(reloaded, this.process);
                entity.toMap().forEach((k, v) -> {
                    if (v != null) {
                        v.toString();
                        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((ProcessInstanceImpl)wpi).getContextInstance("VariableScope");
                        variableScopeInstance.internalSetVariable(k, v);
                    }
                });
                return wpi;
            }
            catch (RuntimeException e) {
                LOGGER.error("Unexpected exception thrown when reloading process instance {}", (Object)instance.id(), (Object)e);
                return null;
            }
        });
    }

    protected ProcessInstance<ProcessInstanceEntity> unmarshallInstance(ProcessInstanceReadMode mode, ProcessInstanceEntity entity) {
        ProcessInstance pi;
        if (mode == ProcessInstanceReadMode.MUTABLE) {
            WorkflowProcessInstance wpi = this.marshaller.unmarshallWorkflowProcessInstance(this.codec.decode(entity.content), this.process);
            entity.toMap().forEach((k, v) -> {
                if (v != null) {
                    v.toString();
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((ProcessInstanceImpl)wpi).getContextInstance("VariableScope");
                    variableScopeInstance.internalSetVariable(k, v);
                }
            });
            pi = ((AbstractProcess)this.process).createInstance(wpi, (Model)entity, entity.version.longValue());
        } else {
            WorkflowProcessInstance wpi = this.marshaller.unmarshallWorkflowProcessInstance(this.codec.decode(entity.content), this.process);
            entity.toMap().forEach((k, v) -> {
                if (v != null) {
                    v.toString();
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((ProcessInstanceImpl)wpi).getContextInstance("VariableScope");
                    variableScopeInstance.internalSetVariable(k, v);
                }
            });
            pi = ((AbstractProcess)this.process).createReadOnlyInstance(wpi, (Model)entity);
        }
        return pi;
    }

    public ExportedProcessInstance exportInstance(ProcessInstance<?> instance, boolean abort) {
        ExportedProcessInstance exported = this.marshaller.exportProcessInstance(this.audit(instance));
        if (abort) {
            instance.abort();
        }
        return exported;
    }

    public ProcessInstance importInstance(ExportedProcessInstance instance, Process process) {
        ProcessInstance imported = this.marshaller.importProcessInstance(instance, process);
        if (this.exists(imported.id())) {
            throw new ProcessInstanceDuplicatedException(imported.id());
        }
        this.create(imported.id(), (ProcessInstance<ProcessInstanceEntity>)imported);
        return imported;
    }

    public ProcessInstance<ProcessInstanceEntity> audit(ProcessInstance<ProcessInstanceEntity> instance) {
        Supplier<AuditEntry> entry = () -> BaseAuditEntry.persitenceWrite((ProcessInstance)instance).add("message", (Object)"Workflow instance was read from the rdbms based data store");
        this.auditor.publish(entry);
        return instance;
    }
}

