/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.persistence.db;

import io.automatiko.engine.api.event.EventManager;
import io.automatiko.engine.services.uow.CollectingUnitOfWork;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class TransactionalUnitOfWork
extends CollectingUnitOfWork {
    private UserTransaction transaction;

    public TransactionalUnitOfWork(EventManager eventManager, UserTransaction transaction) {
        super(eventManager);
        this.transaction = transaction;
    }

    public void start() {
        try {
            this.transaction.begin();
            super.start();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void end() {
        try {
            super.end();
            this.transaction.commit();
        }
        catch (Exception e) {
            try {
                this.transaction.rollback();
            }
            catch (IllegalStateException | SecurityException | SystemException e1) {
                e1.printStackTrace();
            }
            throw new IllegalStateException(e);
        }
    }

    public void abort() {
        try {
            super.abort();
            this.transaction.rollback();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

