/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.persistence.db;

import io.automatiko.engine.addons.persistence.db.JacksonObjectMarshallingStrategy;
import io.automatiko.engine.addons.persistence.db.model.ProcessInstanceEntity;
import io.automatiko.engine.api.Model;
import io.automatiko.engine.api.auth.AccessDeniedException;
import io.automatiko.engine.api.marshalling.ObjectMarshallingStrategy;
import io.automatiko.engine.api.runtime.process.WorkflowProcessInstance;
import io.automatiko.engine.api.workflow.MutableProcessInstances;
import io.automatiko.engine.api.workflow.Process;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.api.workflow.ProcessInstanceReadMode;
import io.automatiko.engine.workflow.AbstractProcess;
import io.automatiko.engine.workflow.AbstractProcessInstance;
import io.automatiko.engine.workflow.base.instance.context.variable.VariableScopeInstance;
import io.automatiko.engine.workflow.base.instance.impl.ProcessInstanceImpl;
import io.automatiko.engine.workflow.marshalling.ProcessInstanceMarshaller;
import io.quarkus.hibernate.orm.panache.runtime.JpaOperations;
import io.quarkus.hibernate.orm.panache.runtime.PanacheQueryImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseProcessInstances
implements MutableProcessInstances<ProcessInstanceEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseProcessInstances.class);
    private final Process<? extends ProcessInstanceEntity> process;
    private ProcessInstanceMarshaller marshaller;
    private Class<? extends ProcessInstanceEntity> type;

    public DatabaseProcessInstances(Process<? extends ProcessInstanceEntity> process) {
        this.process = process;
        this.marshaller = new ProcessInstanceMarshaller(new ObjectMarshallingStrategy[]{new JacksonObjectMarshallingStrategy()});
        this.type = ((Object)((Object)((ProcessInstanceEntity)((Object)process.createModel())))).getClass();
    }

    public Optional<ProcessInstance<ProcessInstanceEntity>> findById(String id, ProcessInstanceReadMode mode) {
        String resolvedId = this.resolveId(id);
        Optional found = JpaOperations.INSTANCE.findByIdOptional(this.type, (Object)resolvedId);
        if (found.isEmpty()) {
            return Optional.empty();
        }
        ProcessInstanceEntity entity = (ProcessInstanceEntity)((Object)found.get());
        return Optional.of(this.unmarshallInstance(mode, entity));
    }

    public Collection<? extends ProcessInstance<ProcessInstanceEntity>> findByIdOrTag(ProcessInstanceReadMode mode, String ... values) {
        return JpaOperations.INSTANCE.stream(this.type, "id in (?1) or (?1) in elements(tags) ", new Object[]{Arrays.asList(values)}).map(e -> {
            try {
                return this.unmarshallInstance(mode, (ProcessInstanceEntity)((Object)((Object)e)));
            }
            catch (AccessDeniedException ex) {
                return null;
            }
        }).filter(pi -> pi != null).collect(Collectors.toSet());
    }

    public Collection<ProcessInstance<ProcessInstanceEntity>> values(ProcessInstanceReadMode mode, int page, int size) {
        return ((PanacheQueryImpl)JpaOperations.INSTANCE.findAll(this.type)).page(this.calculatePage(page, size), size).stream().map(e -> {
            try {
                return this.unmarshallInstance(mode, (ProcessInstanceEntity)((Object)((Object)e)));
            }
            catch (AccessDeniedException ex) {
                return null;
            }
        }).filter(pi -> pi != null).collect(Collectors.toList());
    }

    public Integer size() {
        return (int)JpaOperations.INSTANCE.count(this.type);
    }

    public boolean exists(String id) {
        String resolvedId = this.resolveId(id);
        Optional found = JpaOperations.INSTANCE.findByIdOptional(this.type, (Object)resolvedId);
        return found.isPresent();
    }

    public void create(String id, ProcessInstance<ProcessInstanceEntity> instance) {
        this.store(id, instance);
    }

    public void update(String id, ProcessInstance<ProcessInstanceEntity> instance) {
        this.store(id, instance);
    }

    public void remove(String id, ProcessInstance<ProcessInstanceEntity> instance) {
        ProcessInstanceEntity entity = (ProcessInstanceEntity)((Object)instance.variables());
        JpaOperations.INSTANCE.persist((Object)entity);
        JpaOperations.INSTANCE.deleteById(this.type, (Object)this.resolveId(id, instance));
    }

    protected void store(String id, ProcessInstance<ProcessInstanceEntity> instance) {
        String resolvedId = this.resolveId(id, instance);
        if (this.isActive(instance)) {
            ProcessInstanceEntity entity = (ProcessInstanceEntity)((Object)instance.variables());
            byte[] data = this.marshaller.marhsallProcessInstance(instance);
            if (data == null) {
                return;
            }
            entity.content = data;
            entity.entityId = resolvedId;
            entity.name = instance.description();
            entity.businessKey = instance.businessKey();
            entity.processId = instance.process().id();
            entity.processName = instance.process().name();
            entity.processVersion = instance.process().version();
            entity.startDate = instance.startDate();
            entity.state = instance.status();
            entity.tags = new HashSet<String>(instance.tags().values());
            JpaOperations.INSTANCE.persist((Object)entity);
            this.disconnect(instance);
        }
    }

    protected void disconnect(ProcessInstance<ProcessInstanceEntity> instance) {
        ((AbstractProcessInstance)instance).internalRemoveProcessInstance(() -> {
            try {
                ProcessInstanceEntity entity = (ProcessInstanceEntity)((Object)((Object)JpaOperations.INSTANCE.findById(this.type, (Object)this.resolveId(instance.id(), instance))));
                byte[] reloaded = entity.content;
                WorkflowProcessInstance wpi = this.marshaller.unmarshallWorkflowProcessInstance(reloaded, this.process);
                entity.toMap().forEach((k, v) -> {
                    if (v != null) {
                        v.toString();
                        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((ProcessInstanceImpl)wpi).getContextInstance("VariableScope");
                        variableScopeInstance.internalSetVariable(k, v);
                    }
                });
                return wpi;
            }
            catch (RuntimeException e) {
                LOGGER.error("Unexpected exception thrown when reloading process instance {}", (Object)instance.id(), (Object)e);
                return null;
            }
        });
    }

    protected ProcessInstance<ProcessInstanceEntity> unmarshallInstance(ProcessInstanceReadMode mode, ProcessInstanceEntity entity) {
        ProcessInstance pi;
        if (mode == ProcessInstanceReadMode.MUTABLE) {
            WorkflowProcessInstance wpi = this.marshaller.unmarshallWorkflowProcessInstance(entity.content, this.process);
            entity.toMap().forEach((k, v) -> {
                if (v != null) {
                    v.toString();
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((ProcessInstanceImpl)wpi).getContextInstance("VariableScope");
                    variableScopeInstance.internalSetVariable(k, v);
                }
            });
            pi = ((AbstractProcess)this.process).createInstance(wpi, (Model)entity);
        } else {
            WorkflowProcessInstance wpi = this.marshaller.unmarshallWorkflowProcessInstance(entity.content, this.process);
            entity.toMap().forEach((k, v) -> {
                if (v != null) {
                    v.toString();
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((ProcessInstanceImpl)wpi).getContextInstance("VariableScope");
                    variableScopeInstance.internalSetVariable(k, v);
                }
            });
            pi = ((AbstractProcess)this.process).createReadOnlyInstance(wpi, (Model)entity);
        }
        return pi;
    }
}

