/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.persistence.db;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import io.automatiko.engine.api.marshalling.ObjectMarshallingStrategy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonObjectMarshallingStrategy
implements ObjectMarshallingStrategy {
    private static final Logger logger = LoggerFactory.getLogger(JacksonObjectMarshallingStrategy.class);
    private ObjectMapper mapper = new ObjectMapper().activateDefaultTyping((PolymorphicTypeValidator)BasicPolymorphicTypeValidator.builder().allowIfSubType(Object.class).build(), ObjectMapper.DefaultTyping.EVERYTHING, JsonTypeInfo.As.PROPERTY);

    public boolean accept(Object object) {
        return true;
    }

    public byte[] marshal(ObjectMarshallingStrategy.Context context, ObjectOutputStream os, Object object) throws IOException {
        if (object instanceof Collection) {
            return this.log(this.mapper.writeValueAsBytes(new ArrayList((Collection)object)));
        }
        return this.log(this.mapper.writeValueAsBytes(object));
    }

    public Object unmarshal(String dataType, ObjectMarshallingStrategy.Context context, ObjectInputStream is, byte[] object, ClassLoader classloader) throws IOException, ClassNotFoundException {
        if (object.length == 0) {
            return null;
        }
        return this.mapper.readValue(this.log(object), Object.class);
    }

    public ObjectMarshallingStrategy.Context createContext() {
        return null;
    }

    protected byte[] log(byte[] data) {
        logger.debug("Variable content:: {}", (Object)new String(data, StandardCharsets.UTF_8));
        return data;
    }
}

