/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.persistence.db.job;

import io.automatiko.engine.addons.persistence.db.model.JobInstanceEntity;
import io.automatiko.engine.api.Application;
import io.automatiko.engine.api.Model;
import io.automatiko.engine.api.auth.IdentityProvider;
import io.automatiko.engine.api.auth.TrustedIdentityProvider;
import io.automatiko.engine.api.jobs.ExpirationTime;
import io.automatiko.engine.api.jobs.JobsService;
import io.automatiko.engine.api.jobs.ProcessInstanceJobDescription;
import io.automatiko.engine.api.jobs.ProcessJobDescription;
import io.automatiko.engine.api.uow.UnitOfWorkManager;
import io.automatiko.engine.api.workflow.Process;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.api.workflow.Processes;
import io.automatiko.engine.services.time.TimerInstance;
import io.automatiko.engine.services.uow.UnitOfWorkExecutor;
import io.automatiko.engine.workflow.Sig;
import io.automatiko.engine.workflow.base.core.timer.CronExpirationTime;
import io.automatiko.engine.workflow.base.core.timer.NoOpExpirationTime;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DatabaseJobService
implements JobsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseJobService.class);
    protected final Long interval;
    protected final UnitOfWorkManager unitOfWorkManager;
    protected final ScheduledThreadPoolExecutor scheduler;
    protected final ScheduledThreadPoolExecutor loadScheduler;
    protected ManagedExecutor exec;
    protected Map<String, Process<? extends Model>> mappedProcesses = new HashMap<String, Process<? extends Model>>();
    protected ConcurrentHashMap<String, ScheduledFuture<?>> scheduledJobs = new ConcurrentHashMap();

    @Inject
    public DatabaseJobService(ManagedExecutor exec, @ConfigProperty(name="quarkus.automatiko.jobs.db.interval", defaultValue="10") Long interval, @ConfigProperty(name="quarkus.automatiko.jobs.db.threads", defaultValue="1") int threads, Processes processes, Application application) {
        this.exec = exec;
        this.interval = interval;
        processes.processIds().forEach(id -> this.mappedProcesses.put((String)id, (Process<? extends Model>)processes.processById(id)));
        this.unitOfWorkManager = application.unitOfWorkManager();
        this.scheduler = new ScheduledThreadPoolExecutor(threads, r -> new Thread(r, "automatiko-jobs-executor"));
        this.loadScheduler = new ScheduledThreadPoolExecutor(1, r -> new Thread(r, "automatiko-jobs-loader"));
    }

    public void start(@Observes StartupEvent event) {
        this.loadScheduler.scheduleAtFixedRate(() -> UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.unitOfWorkManager, () -> {
            LocalDateTime next = LocalDateTime.now().plus(Duration.ofMinutes(this.interval));
            List<JobInstanceEntity> jobs = JobInstanceEntity.loadJobs(next);
            LOGGER.debug("Loaded jobs ({}) to be executed before {}", (Object)jobs.size(), (Object)next);
            for (JobInstanceEntity job : jobs) {
                ProcessJobDescription description;
                if (job.ownerInstanceId == null) {
                    description = ProcessJobDescription.of((ExpirationTime)this.build(job), null, (String)job.ownerDefinitionId);
                    this.scheduledJobs.computeIfAbsent(job.id, k -> this.log(job.id, this.scheduler.schedule(new StartProcessOnExpiredTimer(job.id, job.ownerDefinitionId, -1, description), Duration.between(LocalDateTime.now(), job.expirationTime).toMillis(), TimeUnit.MILLISECONDS)));
                    continue;
                }
                description = ProcessInstanceJobDescription.of((String)job.id, (String)job.triggerType, (ExpirationTime)this.build(job), (String)job.ownerInstanceId, (String)job.ownerDefinitionId, null);
                this.scheduledJobs.computeIfAbsent(job.id, arg_0 -> this.lambda$start$4(job, (ProcessInstanceJobDescription)description, arg_0));
            }
            return null;
        }), 1L, this.interval * 60L, TimeUnit.SECONDS);
    }

    public void shutdown(@Observes ShutdownEvent event) {
        this.loadScheduler.shutdownNow();
        this.scheduler.shutdown();
    }

    public String scheduleProcessJob(ProcessJobDescription description) {
        LOGGER.debug("ScheduleProcessJob: {}", (Object)description);
        JobInstanceEntity scheduledJob = null;
        scheduledJob = description.expirationTime().repeatInterval() != null ? new JobInstanceEntity(description.id(), description.process().id(), JobInstanceEntity.JobStatus.SCHEDULED, description.expirationTime().get().toLocalDateTime(), description.expirationTime().repeatLimit(), description.expirationTime().repeatInterval(), description.expirationTime().expression()) : new JobInstanceEntity(description.id(), description.process().id(), JobInstanceEntity.JobStatus.SCHEDULED, description.expirationTime().get().toLocalDateTime(), description.expirationTime().repeatLimit(), null, description.expirationTime().expression());
        JobInstanceEntity persist = scheduledJob;
        UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.unitOfWorkManager, () -> {
            if (JobInstanceEntity.findById((Object)persist.id) == null) {
                JobInstanceEntity.persist((Object)((Object)persist), (Object[])new Object[0]);
            }
            return null;
        });
        if (description.expirationTime().get().toLocalDateTime().isBefore(LocalDateTime.now().plusMinutes(this.interval))) {
            this.scheduledJobs.computeIfAbsent(description.id(), k -> this.scheduler.schedule(this.processJobByDescription(description), this.calculateDelay(description.expirationTime().get()), TimeUnit.MILLISECONDS));
        }
        return description.id();
    }

    public String scheduleProcessInstanceJob(ProcessInstanceJobDescription description) {
        JobInstanceEntity scheduledJob = null;
        scheduledJob = description.expirationTime().repeatInterval() != null ? new JobInstanceEntity(description.id(), description.triggerType(), description.processId() + this.version(description.processVersion()), description.processInstanceId(), JobInstanceEntity.JobStatus.SCHEDULED, description.expirationTime().get().toLocalDateTime(), description.expirationTime().repeatLimit(), description.expirationTime().repeatInterval(), description.expirationTime().expression()) : new JobInstanceEntity(description.id(), description.triggerType(), description.processId() + this.version(description.processVersion()), description.processInstanceId(), JobInstanceEntity.JobStatus.SCHEDULED, description.expirationTime().get().toLocalDateTime(), description.expirationTime().repeatLimit(), null, description.expirationTime().expression());
        JobInstanceEntity.persist((Object)((Object)scheduledJob), (Object[])new Object[0]);
        if (description.expirationTime().get().toLocalDateTime().isBefore(LocalDateTime.now().plusMinutes(this.interval))) {
            this.scheduledJobs.computeIfAbsent(description.id(), k -> this.log(description.id(), this.scheduler.schedule(new SignalProcessInstanceOnExpiredTimer(description.id(), description.triggerType(), description.processId() + this.version(description.processVersion()), description.processInstanceId(), description.expirationTime().repeatLimit(), description), this.calculateDelay(description.expirationTime().get()), TimeUnit.MILLISECONDS)));
        }
        return description.id();
    }

    public boolean cancelJob(String id) {
        return JobInstanceEntity.deleteById((Object)id);
    }

    public ZonedDateTime getScheduledTime(String id) {
        JobInstanceEntity found = (JobInstanceEntity)JobInstanceEntity.findById((Object)id);
        if (found == null) {
            // empty if block
        }
        return ZonedDateTime.of(found.expirationTime, ZoneId.systemDefault());
    }

    protected long calculateDelay(ZonedDateTime expirationDate) {
        return Duration.between(ZonedDateTime.now(), expirationDate).toMillis();
    }

    protected Runnable processJobByDescription(ProcessJobDescription description) {
        return new StartProcessOnExpiredTimer(description.id(), description.process().id(), description.expirationTime().repeatLimit(), description);
    }

    protected String version(String version) {
        if (version != null && !version.trim().isEmpty()) {
            return "_" + version.replaceAll("\\.", "_");
        }
        return "";
    }

    protected void removeScheduledJob(String id) {
        JobInstanceEntity.deleteById((Object)id);
    }

    protected void updateRepeatableJob(String id) {
        JobInstanceEntity job = (JobInstanceEntity)JobInstanceEntity.findById((Object)id);
        job.limit = job.limit - 1;
        job.expirationTime = job.expirationTime.plus(job.repeatInterval, ChronoUnit.MILLIS);
        job.status = JobInstanceEntity.JobStatus.SCHEDULED;
        JobInstanceEntity.persist((Object)((Object)job), (Object[])new Object[0]);
        if (job.ownerInstanceId == null) {
            ProcessJobDescription description = ProcessJobDescription.of((ExpirationTime)this.build(job), null, (String)job.ownerDefinitionId);
            this.scheduledJobs.computeIfAbsent(job.id, k -> this.log(job.id, this.scheduler.schedule(new StartProcessOnExpiredTimer(job.id, job.ownerDefinitionId, job.limit, description), Duration.between(LocalDateTime.now(), job.expirationTime).toMillis(), TimeUnit.MILLISECONDS)));
        } else {
            ProcessInstanceJobDescription description = ProcessInstanceJobDescription.of((String)job.id, (String)job.triggerType, (ExpirationTime)this.build(job), (String)job.ownerInstanceId, (String)job.ownerDefinitionId, null);
            this.scheduledJobs.computeIfAbsent(job.id, k -> this.log(job.id, this.scheduler.scheduleAtFixedRate(new SignalProcessInstanceOnExpiredTimer(job.id, job.triggerType, job.ownerDefinitionId, job.ownerInstanceId, job.limit, description), Duration.between(LocalDateTime.now(), job.expirationTime).toMillis(), job.repeatInterval, TimeUnit.MILLISECONDS)));
        }
    }

    protected ScheduledFuture<?> log(String jobId, ScheduledFuture<?> future) {
        LOGGER.debug("Next fire of job {} is in {} seconds ", (Object)jobId, (Object)future.getDelay(TimeUnit.SECONDS));
        return future;
    }

    protected ExpirationTime build(JobInstanceEntity job) {
        if (job.expression != null) {
            return CronExpirationTime.of((String)job.expression);
        }
        return new NoOpExpirationTime();
    }

    private /* synthetic */ ScheduledFuture lambda$start$4(JobInstanceEntity job, ProcessInstanceJobDescription description, String k) {
        return this.log(job.id, this.scheduler.schedule(new SignalProcessInstanceOnExpiredTimer(job.id, job.triggerType, job.ownerDefinitionId, job.ownerInstanceId, job.limit, description), Duration.between(LocalDateTime.now(), job.expirationTime).toMillis(), TimeUnit.MILLISECONDS));
    }

    private class StartProcessOnExpiredTimer
    implements Runnable {
        private final String id;
        private final String processId;
        private Integer limit;
        private ProcessJobDescription description;

        private StartProcessOnExpiredTimer(String id, String processId, Integer limit, ProcessJobDescription description) {
            this.id = id;
            this.processId = processId;
            this.limit = limit;
            this.description = description;
        }

        @Override
        public void run() {
            LOGGER.debug("Job {} started", (Object)this.id);
            boolean acquired = (Boolean)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)DatabaseJobService.this.unitOfWorkManager, () -> {
                JobInstanceEntity job = JobInstanceEntity.acquireJob(this.id);
                if (job == null) {
                    return false;
                }
                job.status = JobInstanceEntity.JobStatus.TAKEN;
                JobInstanceEntity.persist((Object)((Object)job), (Object[])new Object[0]);
                return true;
            });
            if (!acquired) {
                DatabaseJobService.this.scheduledJobs.remove(this.id).cancel(true);
                return;
            }
            Process<? extends Model> process = DatabaseJobService.this.mappedProcesses.get(this.processId);
            if (process == null) {
                LOGGER.warn("No process found for process id {}", (Object)this.processId);
                return;
            }
            IdentityProvider.set((IdentityProvider)new TrustedIdentityProvider("System<timer>"));
            UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)DatabaseJobService.this.unitOfWorkManager, () -> {
                ProcessInstance pi = process.createInstance(process.createModel());
                if (pi != null) {
                    pi.start("timer", null, null);
                }
                DatabaseJobService.this.scheduledJobs.remove(this.id).cancel(false);
                Integer n = this.limit;
                Integer n2 = this.limit = Integer.valueOf(this.limit - 1);
                if (this.description.expirationTime().next() != null) {
                    JobInstanceEntity.deleteById((Object)this.id);
                    DatabaseJobService.this.scheduleProcessJob(this.description);
                } else if (this.limit > 0) {
                    DatabaseJobService.this.updateRepeatableJob(this.id);
                } else {
                    JobInstanceEntity.deleteById((Object)this.id);
                }
                return null;
            });
            LOGGER.debug("Job {} completed", (Object)this.id);
        }
    }

    private class SignalProcessInstanceOnExpiredTimer
    implements Runnable {
        private final String id;
        private final String processId;
        private String processInstanceId;
        private final String trigger;
        private Integer limit;
        private ProcessInstanceJobDescription description;

        private SignalProcessInstanceOnExpiredTimer(String id, String trigger, String processId, String processInstanceId, Integer limit, ProcessInstanceJobDescription description) {
            this.id = id;
            this.processId = processId;
            this.processInstanceId = processInstanceId;
            this.trigger = trigger;
            this.limit = limit;
            this.description = description;
        }

        @Override
        public void run() {
            LOGGER.debug("Job {} started", (Object)this.id);
            boolean acquired = (Boolean)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)DatabaseJobService.this.unitOfWorkManager, () -> {
                JobInstanceEntity job = JobInstanceEntity.acquireJob(this.id);
                if (job == null || job.status != JobInstanceEntity.JobStatus.SCHEDULED) {
                    return false;
                }
                job.status = JobInstanceEntity.JobStatus.TAKEN;
                JobInstanceEntity.persist((Object)((Object)job), (Object[])new Object[0]);
                return true;
            });
            if (!acquired) {
                DatabaseJobService.this.scheduledJobs.remove(this.id).cancel(true);
                return;
            }
            Process<? extends Model> process = DatabaseJobService.this.mappedProcesses.get(this.processId);
            if (process == null) {
                LOGGER.warn("No process found for process id {}", (Object)this.processId);
                return;
            }
            IdentityProvider.set((IdentityProvider)new TrustedIdentityProvider("System<timer>"));
            UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)DatabaseJobService.this.unitOfWorkManager, () -> {
                Optional processInstanceFound = process.instances().findById(this.processInstanceId);
                if (processInstanceFound.isPresent()) {
                    ProcessInstance processInstance = (ProcessInstance)processInstanceFound.get();
                    String[] ids = this.id.split("_");
                    processInstance.send(Sig.of((String)this.trigger, (Object)TimerInstance.with((long)Long.parseLong(ids[1]), (String)this.id, (Integer)this.limit)));
                    DatabaseJobService.this.scheduledJobs.remove(this.id).cancel(false);
                    if (this.description.expirationTime().next() != null) {
                        JobInstanceEntity.deleteById((Object)this.id);
                        DatabaseJobService.this.scheduleProcessInstanceJob(this.description);
                    } else if (this.limit > 0) {
                        DatabaseJobService.this.updateRepeatableJob(this.id);
                    } else {
                        JobInstanceEntity.deleteById((Object)this.id);
                    }
                } else {
                    DatabaseJobService.this.scheduledJobs.remove(this.id).cancel(false);
                    DatabaseJobService.this.removeScheduledJob(this.id);
                }
                return null;
            });
            LOGGER.debug("Job {} completed", (Object)this.id);
        }
    }
}

