/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.addons.graphql;

import io.automatiko.addons.graphql.GraphQLEventPublisher;
import io.automatiko.addons.graphql.GraphQLSubscriptionEventPublisher;
import io.automatiko.addons.graphql.internal.SecurityAwareBroadcastProcessor;
import io.automatiko.engine.api.event.DataEvent;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.services.event.ProcessInstanceDataEvent;
import io.automatiko.engine.services.event.impl.ProcessInstanceEventBody;
import java.util.function.Function;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;

@Dependent
public class GraphQLProcessSubscriptionEventPublisher<T>
implements GraphQLSubscriptionEventPublisher<T> {
    SecurityAwareBroadcastProcessor<T> createdProcessor = SecurityAwareBroadcastProcessor.create();
    SecurityAwareBroadcastProcessor<T> completedProcessor = SecurityAwareBroadcastProcessor.create();
    SecurityAwareBroadcastProcessor<T> abortedProcessor = SecurityAwareBroadcastProcessor.create();
    SecurityAwareBroadcastProcessor<T> inErrorProcessor = SecurityAwareBroadcastProcessor.create();
    SecurityAwareBroadcastProcessor<T> changedProcessor = SecurityAwareBroadcastProcessor.create();
    GraphQLEventPublisher publisher;
    private String processId;
    private Function<ProcessInstance<?>, T> mapper;

    @Inject
    public GraphQLProcessSubscriptionEventPublisher(GraphQLEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public void process(DataEvent<?> event) {
        ProcessInstanceDataEvent piEvent;
        ProcessInstance instance;
        if (this.processId == null || this.mapper == null) {
            return;
        }
        if (event instanceof ProcessInstanceDataEvent && (instance = ((ProcessInstanceEventBody)(piEvent = (ProcessInstanceDataEvent)event).getData()).sourceInstance()).process().id().equals(this.processId)) {
            if (instance.status() == 2) {
                this.completedProcessor.onNext(this.mapper.apply(instance), ((ProcessInstanceEventBody)piEvent.getData()).getVisibleTo());
            } else if (instance.status() == 3) {
                this.abortedProcessor.onNext(this.mapper.apply(instance), ((ProcessInstanceEventBody)piEvent.getData()).getVisibleTo());
            } else if (instance.status() == 5) {
                this.inErrorProcessor.onNext(this.mapper.apply(instance), ((ProcessInstanceEventBody)piEvent.getData()).getVisibleTo());
            } else {
                this.changedProcessor.onNext(this.mapper.apply(instance), ((ProcessInstanceEventBody)piEvent.getData()).getVisibleTo());
            }
        }
    }

    public void configure(String processId, Function<ProcessInstance<?>, T> mapper) {
        this.processId = processId;
        this.mapper = mapper;
        this.publisher.register(this);
    }

    public SecurityAwareBroadcastProcessor<T> created(T clazz) {
        return this.createdProcessor;
    }

    public SecurityAwareBroadcastProcessor<T> completed(T clazz) {
        return this.completedProcessor;
    }

    public SecurityAwareBroadcastProcessor<T> aborted(T clazz) {
        return this.abortedProcessor;
    }

    public SecurityAwareBroadcastProcessor<T> inError(T clazz) {
        return this.inErrorProcessor;
    }

    public SecurityAwareBroadcastProcessor<T> changed(T clazz) {
        return this.changedProcessor;
    }
}

