/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.addons.graphql.internal;

import io.automatiko.engine.api.auth.IdentityProvider;
import io.automatiko.engine.api.auth.SecurityPolicy;
import io.automatiko.engine.api.runtime.process.HumanTaskWorkItem;
import io.automatiko.engine.api.workflow.workitem.Policy;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.operators.multi.processors.SerializedProcessor;
import io.smallrye.mutiny.subscription.BackPressureFailure;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SecurityAwareBroadcastProcessor<T>
extends AbstractMulti<T>
implements Processor<T, T> {
    static final List<?> TERMINATED = new ArrayList(0);
    final AtomicReference<List<BroadcastSubscription<T>>> subscribers = new AtomicReference(new CopyOnWriteArrayList());
    Throwable failure;

    public static <T> SecurityAwareBroadcastProcessor<T> create() {
        return new SecurityAwareBroadcastProcessor<T>();
    }

    private SecurityAwareBroadcastProcessor() {
    }

    public SerializedProcessor<T, T> serialized() {
        return new SerializedProcessor((Processor)this);
    }

    private boolean addSubscription(BroadcastSubscription<T> sub) {
        List<BroadcastSubscription<T>> current = this.subscribers.get();
        if (current == TERMINATED) {
            return false;
        }
        return current.add(sub);
    }

    void remove(BroadcastSubscription<T> sub) {
        List<BroadcastSubscription<T>> current = this.subscribers.get();
        if (current == TERMINATED || current.isEmpty()) {
            return;
        }
        current.remove(sub);
    }

    public void subscribe(MultiSubscriber<? super T> downstream) {
        BroadcastSubscription<T> subscription = new BroadcastSubscription<T>(downstream, this, IdentityProvider.get());
        downstream.onSubscribe(subscription);
        if (this.addSubscription(subscription)) {
            if (subscription.isCancelled()) {
                this.remove(subscription);
            }
        } else {
            Throwable ex = this.failure;
            if (ex != null) {
                downstream.onFailure(ex);
            } else {
                downstream.onCompletion();
            }
        }
    }

    public void onSubscribe(Subscription subscription) {
        if (this.subscribers.get() == TERMINATED) {
            subscription.cancel();
            return;
        }
        subscription.request(Long.MAX_VALUE);
    }

    public void onNext(T item) {
        ParameterValidation.nonNullNpe(item, (String)"item");
        for (BroadcastSubscription<T> s : this.subscribers.get()) {
            s.onNext(item);
        }
    }

    public void onNext(T item, Collection<String> visibleTo) {
        ParameterValidation.nonNullNpe(item, (String)"item");
        for (BroadcastSubscription<T> s : this.subscribers.get()) {
            IdentityProvider identityProvider = s.identityProvider();
            boolean allowed = visibleTo.isEmpty() || visibleTo.contains(identityProvider.getName()) || visibleTo.stream().anyMatch(i -> identityProvider.getRoles().contains(i));
            if (!allowed) continue;
            s.onNext(item);
        }
    }

    public void onNext(T item, HumanTaskWorkItem workItem) {
        ParameterValidation.nonNullNpe(item, (String)"item");
        for (BroadcastSubscription<T> s : this.subscribers.get()) {
            IdentityProvider identityProvider = s.identityProvider();
            boolean allowed = workItem.enforce(new Policy[]{SecurityPolicy.of((IdentityProvider)identityProvider)});
            if (!allowed) continue;
            s.onNext(item);
        }
    }

    public void onError(Throwable failure) {
        ParameterValidation.nonNullNpe((Object)failure, (String)"failure");
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        this.failure = failure;
        List<?> andSet = this.subscribers.getAndSet(TERMINATED);
        for (BroadcastSubscription s : andSet) {
            s.onError(failure);
        }
    }

    public void onComplete() {
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        List<?> andSet = this.subscribers.getAndSet(TERMINATED);
        for (BroadcastSubscription s : andSet) {
            s.onComplete();
        }
    }

    static final class BroadcastSubscription<T>
    implements Subscription {
        private final Subscriber<? super T> downstream;
        private final SecurityAwareBroadcastProcessor<T> parent;
        private final AtomicLong requests = new AtomicLong();
        private final IdentityProvider identityProvider;

        BroadcastSubscription(Subscriber<? super T> actual, SecurityAwareBroadcastProcessor<T> parent, IdentityProvider identityProvider) {
            this.downstream = actual;
            this.parent = parent;
            this.identityProvider = identityProvider;
        }

        public void onNext(T t) {
            long r = this.requests.get();
            if (r == Long.MIN_VALUE) {
                return;
            }
            if (r != 0L) {
                this.downstream.onNext(t);
                Subscriptions.producedAndHandleAlreadyCancelled((AtomicLong)this.requests, (long)1L);
            } else {
                this.cancel();
                this.downstream.onError((Throwable)new BackPressureFailure("Could not emit item downstream due to lack of requests"));
            }
        }

        public void onError(Throwable t) {
            if (this.requests.get() != Long.MIN_VALUE) {
                this.downstream.onError(t);
            }
        }

        public void onComplete() {
            if (this.requests.get() != Long.MIN_VALUE) {
                this.downstream.onComplete();
            }
        }

        public void request(long n) {
            if (n > 0L) {
                Subscriptions.addAndHandledAlreadyCancelled((AtomicLong)this.requests, (long)n);
            }
        }

        public void cancel() {
            if (this.requests.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.remove(this);
            }
        }

        public boolean isCancelled() {
            return this.requests.get() == Long.MIN_VALUE;
        }

        public IdentityProvider identityProvider() {
            return this.identityProvider;
        }
    }
}

