/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.addons.graphql.ut;

import io.automatiko.addons.graphql.ut.GraphQLUserTaskSubscriptionEventPublisher;
import io.automatiko.addons.graphql.ut.UserTaskEventInput;
import io.automatiko.engine.api.auth.IdentityProvider;
import io.automatiko.engine.api.auth.IdentitySupplier;
import io.smallrye.graphql.api.Subscription;
import io.smallrye.mutiny.Multi;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.graphql.DefaultValue;
import org.eclipse.microprofile.graphql.Description;
import org.eclipse.microprofile.graphql.GraphQLApi;
import org.eclipse.microprofile.graphql.Name;

@ApplicationScoped
@Description(value="Dedicated GraphQL API to user tasks for the complete service")
@GraphQLApi
public class UserTaskSubscriptionResource {
    GraphQLUserTaskSubscriptionEventPublisher subscriptionPublisher;
    IdentitySupplier identitySupplier;

    @Inject
    public void $Type$GraphQLResource(IdentitySupplier identitySupplier, GraphQLUserTaskSubscriptionEventPublisher subscriptionPublisher) {
        this.identitySupplier = identitySupplier;
        this.subscriptionPublisher = subscriptionPublisher;
    }

    @Subscription
    @Description(value="Emits on every change (create, complete, abort) of user task within the service")
    public Multi<UserTaskEventInput> userTasks(@Name(value="user") @DefaultValue(value="") String user, @Name(value="groups") List<String> groups) {
        this.identitySupplier.buildIdentityProvider(user, groups);
        return this.subscriptionPublisher.userTask().onSubscribe().invoke(() -> IdentityProvider.set(null));
    }
}

