/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.usertasks.email;

import io.automatiko.engine.addons.usertasks.email.EmailAddressResolver;
import io.automatiko.engine.api.definition.process.Process;
import io.automatiko.engine.api.runtime.process.HumanTaskWorkItem;
import io.automatiko.engine.api.runtime.process.WorkItem;
import io.automatiko.engine.api.runtime.process.WorkItemManager;
import io.automatiko.engine.api.workflow.workitem.LifeCyclePhase;
import io.automatiko.engine.api.workflow.workitem.Transition;
import io.automatiko.engine.workflow.base.instance.impl.humantask.BaseHumanTaskLifeCycle;
import io.quarkus.mailer.Mail;
import io.quarkus.mailer.Mailer;
import io.quarkus.qute.Engine;
import io.quarkus.qute.Template;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanTaskLifeCycleWithEmail
extends BaseHumanTaskLifeCycle {
    private static final String DEFAULT_TEMPLATE = "default-usertask-email";
    private static final String TEMPLATE_SUFFIX = "-email";
    private static final Logger LOGGER = LoggerFactory.getLogger(HumanTaskLifeCycleWithEmail.class);
    private Mailer mailer;
    private EmailAddressResolver emailAddressResolver;
    private Engine engine;
    private String serviceUrl;

    public HumanTaskLifeCycleWithEmail(Mailer mailer, EmailAddressResolver emailAddressResolver, Engine engine, Optional<String> serviceUrl) {
        this.mailer = mailer;
        this.emailAddressResolver = emailAddressResolver;
        this.engine = engine;
        this.serviceUrl = serviceUrl.orElse("http://localhost:8080");
    }

    public Map<String, Object> transitionTo(WorkItem workItem, WorkItemManager manager, Transition<Map<String, Object>> transition) {
        Map data = super.transitionTo(workItem, manager, transition);
        LifeCyclePhase targetPhase = this.phaseById(transition.phase());
        if (targetPhase.id().equals("active")) {
            this.sendEmail(workItem);
        }
        return data;
    }

    private void sendEmail(WorkItem workItem) {
        Map<String, String> addresses;
        HumanTaskWorkItem humanTask = (HumanTaskWorkItem)workItem;
        ArrayList<String> users = new ArrayList<String>();
        if (humanTask.getActualOwner() != null) {
            users.add(humanTask.getActualOwner());
        }
        if (humanTask.getPotentialUsers() != null) {
            users.addAll(humanTask.getPotentialUsers());
        }
        if ((addresses = this.emailAddressResolver.resolve(users, humanTask.getPotentialGroups())).isEmpty()) {
            return;
        }
        String subject = "New task has been assigned to you (" + humanTask.getTaskName() + ")";
        Template template = this.getTemplate(humanTask.getProcessInstance().getProcess(), humanTask);
        if (template == null) {
            template = this.engine.getTemplate(DEFAULT_TEMPLATE);
        }
        Mail[] emails = new Mail[addresses.size()];
        HashMap<String, Object> templateData = new HashMap<String, Object>();
        templateData.put("name", humanTask.getTaskName());
        templateData.put("description", humanTask.getTaskDescription());
        templateData.put("taskId", humanTask.getId());
        templateData.put("instanceId", humanTask.getProcessInstanceId());
        templateData.put("processId", humanTask.getProcessInstance().getProcessId());
        templateData.put("inputs", humanTask.getParameters());
        int count = 0;
        for (Map.Entry<String, String> address : addresses.entrySet()) {
            Object parentProcessInstanceId;
            String dedicatedTo = "";
            if (users.contains(address.getKey())) {
                dedicatedTo = address.getKey();
            }
            parentProcessInstanceId = (parentProcessInstanceId = humanTask.getProcessInstance().getParentProcessInstanceId()) != null && !((String)parentProcessInstanceId).isEmpty() ? (String)parentProcessInstanceId + ":" : "";
            String version = this.version(humanTask.getProcessInstance().getProcess().getVersion());
            String encoded = Base64.getEncoder().encodeToString((humanTask.getProcessInstance().getProcessId() + version + "|" + (String)parentProcessInstanceId + humanTask.getProcessInstance().getId() + "|" + humanTask.getId() + "|" + dedicatedTo).getBytes(StandardCharsets.UTF_8));
            String link = this.serviceUrl + "/management/tasks/link/" + encoded;
            templateData.put("link", link);
            String body = template.instance().data(templateData).render();
            emails[count] = Mail.withHtml((String)address.getValue(), (String)subject, (String)body);
            ++count;
        }
        CompletableFuture.runAsync(() -> {
            for (String to : addresses.values()) {
                this.mailer.send(emails);
                LOGGER.debug("Email sent to {} with new assigned task {}", (Object)to, (Object)humanTask.getName());
            }
        });
    }

    protected Template getTemplate(Process process, HumanTaskWorkItem humanTask) {
        Template template = this.engine.getTemplate(process.getId() + this.version(process.getVersion()) + "." + humanTask.getParameters().getOrDefault("TaskName", humanTask.getTaskName()) + TEMPLATE_SUFFIX);
        if (template == null) {
            template = this.engine.getTemplate(humanTask.getParameters().getOrDefault("TaskName", humanTask.getTaskName()) + TEMPLATE_SUFFIX);
        }
        return template;
    }

    protected String version(String version) {
        if (version != null && !version.trim().isEmpty()) {
            return "_" + version.replaceAll("\\.", "_");
        }
        return "";
    }
}

