/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.usertasks.email.impl;

import io.automatiko.engine.addons.usertasks.email.EmailAddressResolver;
import io.quarkus.arc.DefaultBean;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;

@DefaultBean
@ApplicationScoped
public class DefaultEmailAddressResolver
implements EmailAddressResolver {
    private static final String EMAIL_REGEX = "^\\s*?(.+)@(.+?)\\s*$";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^\\s*?(.+)@(.+?)\\s*$");

    @Override
    public Map<String, String> resolve(Collection<String> users, Collection<String> groups) {
        HashMap<String, String> emails = new HashMap<String, String>();
        if (users != null) {
            users.stream().filter(s -> EMAIL_PATTERN.matcher((CharSequence)s).matches()).forEach(s -> emails.put((String)s, (String)s));
        }
        if (groups != null) {
            groups.stream().filter(s -> EMAIL_PATTERN.matcher((CharSequence)s).matches()).forEach(s -> emails.put((String)s, (String)s));
        }
        return emails;
    }
}

