/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.addon.usertasks.index;

import io.automatiko.engine.api.Application;
import io.automatiko.engine.api.auth.IdentityProvider;
import io.automatiko.engine.api.auth.IdentitySupplier;
import io.automatiko.engine.api.auth.TrustedIdentityProvider;
import io.automatiko.engine.api.runtime.process.NodeInstance;
import io.automatiko.engine.api.uow.UnitOfWork;
import io.automatiko.engine.api.uow.WorkUnit;
import io.automatiko.engine.api.workflow.Process;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.api.workflow.ProcessInstanceReadMode;
import io.automatiko.engine.api.workflow.workitem.Transition;
import io.automatiko.engine.workflow.AbstractProcessInstance;
import io.automatiko.engine.workflow.base.core.event.ProcessWorkItemTransitionEventImpl;
import io.automatiko.engine.workflow.base.instance.impl.humantask.HumanTaskTransition;
import io.automatiko.engine.workflow.process.instance.impl.WorkflowProcessInstanceImpl;
import io.automatiko.engine.workflow.process.instance.node.HumanTaskNodeInstance;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(name="User task index Management", description="User task index management on top of the service")
@Path(value="/management/index/tasks")
public class UserTaskIndexManagementResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTaskIndexManagementResource.class);
    protected Map<String, Process<?>> processData = new LinkedHashMap();
    protected Application application;
    protected IdentitySupplier identitySupplier;

    public UserTaskIndexManagementResource() {
    }

    @Inject
    public UserTaskIndexManagementResource(Application application, Instance<Process<?>> availableProcesses, IdentitySupplier identitySupplier) {
        this.processData = availableProcesses == null ? Collections.emptyMap() : availableProcesses.stream().collect(Collectors.toMap(p -> p.id(), p -> p));
        this.application = application;
        this.identitySupplier = identitySupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json"})
    public Response reindexAll() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        IdentityProvider.set((IdentityProvider)new TrustedIdentityProvider("System<reindex>"));
        try {
            for (Process<?> process : this.processData.values()) {
                UnitOfWork uow = this.application.unitOfWorkManager().newUnitOfWork();
                uow.start();
                int indexedInstances = 0;
                Collection<ProcessInstance<?>> instances = this.loadProcessInstances(process);
                for (ProcessInstance<?> instance : instances) {
                    try {
                        indexedInstances += this.indexProcessInstance(uow, process, instance);
                    }
                    catch (Throwable e) {
                        LOGGER.warn("Unable to reindex user tasks for instance {} and process {} due to {}", (Object)process.id(), (Object)instance.id());
                    }
                }
                uow.end();
                result.put(process.id(), indexedInstances);
            }
        }
        finally {
            IdentityProvider.set(null);
        }
        result.put("message", "User tasks reindexed");
        return Response.ok().entity(result).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/{processId}")
    @POST
    @Produces(value={"application/json"})
    public Response reindexProcess(@PathParam(value="processId") String processId) {
        UnitOfWork uow = this.application.unitOfWorkManager().newUnitOfWork();
        uow.start();
        Process<?> process = this.processData.get(processId);
        if (process == null) {
            return Response.status((int)404).entity(Map.of("message", "Process with id '" + processId + "' was not found")).build();
        }
        int indexedInstances = 0;
        IdentityProvider.set((IdentityProvider)new TrustedIdentityProvider("System<reindex>"));
        try {
            Collection<ProcessInstance<?>> instances = this.loadProcessInstances(process);
            for (ProcessInstance<?> instance : instances) {
                try {
                    indexedInstances = this.indexProcessInstance(uow, process, instance);
                }
                catch (Throwable e) {
                    LOGGER.warn("Unable to reindex user tasks for instance {} and process {} due to {}", (Object)process.id(), (Object)instance.id());
                }
            }
        }
        finally {
            IdentityProvider.set(null);
        }
        uow.end();
        return Response.ok().entity(Map.of("message", "User tasks for process " + processId + " reindexed", "count", indexedInstances)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/{processId}/{instanceId}")
    @POST
    @Produces(value={"application/json"})
    public Response reindexProcessInstance(@PathParam(value="processId") String processId, @PathParam(value="instanceId") String instanceId) {
        UnitOfWork uow = this.application.unitOfWorkManager().newUnitOfWork();
        uow.start();
        Process<?> process = this.processData.get(processId);
        if (process == null) {
            return Response.status((int)404).entity(Map.of("message", "Process with id '" + processId + "' was not found")).build();
        }
        int indexedInstances = 0;
        IdentityProvider.set((IdentityProvider)new TrustedIdentityProvider("System<reindex>"));
        try {
            Optional<ProcessInstance<?>> instance = this.loadProcessInstance(process, instanceId);
            if (instance.isEmpty()) {
                Response response = Response.status((int)404).entity(Map.of("message", "Process instance with id '" + instanceId + "' was not found")).build();
                return response;
            }
            indexedInstances = this.indexProcessInstance(uow, process, instance.get());
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to reindex user tasks for instance {} and process {} due to {}", (Object)process.id(), (Object)instanceId);
        }
        finally {
            IdentityProvider.set(null);
        }
        uow.end();
        return Response.ok().entity(Map.of("message", "User tasks for process instance " + instanceId + " reindexed", "count", indexedInstances)).build();
    }

    protected int indexProcessInstance(UnitOfWork uow, Process<?> process, ProcessInstance<?> instance) {
        int count = 0;
        WorkflowProcessInstanceImpl workflowInstance = (WorkflowProcessInstanceImpl)((AbstractProcessInstance)instance).internalGetProcessInstance();
        Collection nodeInstances = workflowInstance.getNodeInstances(true);
        for (NodeInstance nodeInstance : nodeInstances) {
            if (!(nodeInstance instanceof HumanTaskNodeInstance)) continue;
            ProcessWorkItemTransitionEventImpl event = new ProcessWorkItemTransitionEventImpl((io.automatiko.engine.api.runtime.process.ProcessInstance)workflowInstance, ((HumanTaskNodeInstance)nodeInstance).getWorkItem(), (Transition)new HumanTaskTransition(((HumanTaskNodeInstance)nodeInstance).getWorkItem().getPhaseId()), null, true);
            uow.intercept(WorkUnit.create((Object)event, e -> {}));
            ++count;
        }
        for (ProcessInstance subInstance : instance.subprocesses()) {
            count += this.indexProcessInstance(uow, subInstance.process(), subInstance);
        }
        return count;
    }

    protected Optional<ProcessInstance<?>> loadProcessInstance(Process<?> process, String instanceId) {
        Optional instance = process.instances().findById(instanceId, ProcessInstanceReadMode.READ_ONLY);
        if (instance.isEmpty()) {
            instance = process.instances().findById(instanceId, 5, ProcessInstanceReadMode.READ_ONLY);
        }
        return instance;
    }

    protected Collection<ProcessInstance<?>> loadProcessInstances(Process<?> process) {
        Collection activeInstances = process.instances().values(ProcessInstanceReadMode.READ_ONLY, 1, Integer.MAX_VALUE);
        Collection errorIinstances = process.instances().values(ProcessInstanceReadMode.READ_ONLY, 5, 1, Integer.MAX_VALUE);
        ArrayList instances = new ArrayList();
        instances.addAll(activeInstances);
        instances.addAll(errorIinstances);
        return instances;
    }
}

