/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.addon.usertasks.index;

import io.automatiko.addon.usertasks.index.UserTask;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collection;
import java.util.List;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;

@Tag(name="User task search", description="Allows to search for user tasks across all processes based on user/group assignment")
@Path(value="/index/usertasks")
public interface UserTaskIndexResource {
    @GET
    @Produces(value={"application/json"})
    public Collection<? extends UserTask> findTasks(@Parameter(description="Name of the task to search for (supports partial patch)", required=false) @QueryParam(value="name") String var1, @Parameter(description="Description of the task to search for (supports partial match)", required=false) @QueryParam(value="description") String var2, @Parameter(description="State of the task (exact match)", required=false) @QueryParam(value="state") String var3, @Parameter(description="Priority of the task (exact match)", required=false) @QueryParam(value="priority") String var4, @Parameter(description="Pagination - page to start on", required=false) @QueryParam(value="page") @DefaultValue(value="1") int var5, @Parameter(description="Pagination - number of items to return", required=false) @QueryParam(value="size") @DefaultValue(value="10") int var6, @Parameter(description="Sorting - name of the field to sort by (description, startDate, completeDate, businessKey)", required=false) @QueryParam(value="sortBy") String var7, @Parameter(description="Sorting - direction of sorting ascending or descending", required=false) @QueryParam(value="sortAsc") @DefaultValue(value="true") boolean var8, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String var9, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> var10);

    @Path(value="/{id}")
    @GET
    @Produces(value={"application/json"})
    public UserTask findTask(@Parameter(description="Unique identifier to get the task", required=true) @PathParam(value="id") String var1, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String var2, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> var3);

    @Path(value="/queries/{name}")
    @GET
    @Produces(value={"application/json"})
    public Collection<? extends UserTask> queryTasks(@Context UriInfo var1, @Parameter(description="Unique name of the query to be used to produce filter", required=true) @PathParam(value="name") String var2, @Parameter(description="Pagination - page to start on", required=false) @QueryParam(value="page") @DefaultValue(value="1") int var3, @Parameter(description="Pagination - number of items to return", required=false) @QueryParam(value="size") @DefaultValue(value="10") int var4, @Parameter(description="Sorting - name of the field to sort by (description, startDate, completeDate, businessKey)", required=false) @QueryParam(value="sortBy") String var5, @Parameter(description="Sorting - direction of sorting ascending or descending", required=false) @QueryParam(value="sortAsc") @DefaultValue(value="true") boolean var6, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String var7, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> var8);
}

