/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.api.auth;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface IdentityProvider {
    public static final String UNKNOWN_USER_IDENTITY = "unknown";
    public static final ThreadLocal<IdentityProvider> current = new ThreadLocal();

    public String getName();

    public List<String> getRoles();

    public boolean hasRole(String var1);

    default public boolean isAdmin() {
        return this.hasRole("admin");
    }

    public Map<String, Object> properties();

    public static IdentityProvider get() {
        IdentityProvider identity = current.get();
        if (identity == null) {
            return new IdentityProvider(){

                @Override
                public boolean hasRole(String role) {
                    return false;
                }

                @Override
                public List<String> getRoles() {
                    return Collections.emptyList();
                }

                @Override
                public String getName() {
                    return null;
                }

                @Override
                public Map<String, Object> properties() {
                    return Collections.emptyMap();
                }
            };
        }
        return identity;
    }

    public static void set(IdentityProvider identityProvider) {
        current.set(identityProvider);
    }

    public static boolean isSet() {
        return current.get() != null;
    }
}

