/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.api.event;

import io.automatiko.engine.api.event.DataEvent;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class AbstractDataEvent<T>
implements DataEvent<T> {
    protected String specversion;
    protected String id;
    protected String source;
    protected String type;
    protected String time;
    protected String subject;
    protected String datacontenttype;
    protected T data;
    protected Map<String, Object> extensions = new HashMap<String, Object>();

    public AbstractDataEvent(String type, String source, T body) {
        this.specversion = "1.0.1";
        this.id = UUID.randomUUID().toString();
        this.source = source;
        this.type = type;
        this.time = ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.datacontenttype = "application/json";
        this.data = body;
    }

    public AbstractDataEvent(String specversion, String id, String source, String type, String subject, String time, T data) {
        this.specversion = specversion;
        this.id = id;
        this.source = source;
        this.type = type;
        this.subject = subject;
        this.time = time == null ? ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) : time;
        this.datacontenttype = "application/json";
        this.data = data;
    }

    public AbstractDataEvent(String specversion, String id, String source, String type, String subject, String time, String datacontenttype, T data) {
        this.specversion = specversion;
        this.id = id;
        this.source = source;
        this.type = type;
        this.subject = subject;
        this.time = time;
        this.datacontenttype = datacontenttype;
        this.data = data;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getSpecversion() {
        return this.specversion;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTime() {
        return this.time;
    }

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    @Override
    public void addExtension(String name, Object value) {
        this.extensions.put(name, value);
    }

    @Override
    public Object getExtension(String name) {
        return this.extensions.get(name);
    }
}

