/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.api.jobs;

import io.automatiko.engine.api.jobs.ExpirationTime;
import io.automatiko.engine.api.jobs.JobDescription;
import java.util.Objects;
import java.util.UUID;

public class ProcessInstanceJobDescription
implements JobDescription {
    public static final Integer DEFAULT_PRIORITY = 5;
    private final String id;
    private final ExpirationTime expirationTime;
    private final Integer priority;
    private final String processInstanceId;
    private final String rootProcessInstanceId;
    private final String processId;
    private final String processVersion;
    private final String rootProcessId;
    private final String triggerType;

    private ProcessInstanceJobDescription(long timerId, ExpirationTime expirationTime, Integer priority, String processInstanceId, String rootProcessInstanceId, String processId, String processVersion, String rootProcessId, String triggerType) {
        this.id = UUID.randomUUID().toString() + "_" + timerId;
        this.expirationTime = Objects.requireNonNull(expirationTime);
        this.priority = Objects.requireNonNull(priority);
        this.processInstanceId = Objects.requireNonNull(processInstanceId);
        this.rootProcessInstanceId = rootProcessInstanceId;
        this.processId = processId;
        this.processVersion = processVersion;
        this.rootProcessId = rootProcessId;
        this.triggerType = Objects.requireNonNull(triggerType);
    }

    private ProcessInstanceJobDescription(String jobId, long timerId, ExpirationTime expirationTime, Integer priority, String processInstanceId, String rootProcessInstanceId, String processId, String processVersion, String rootProcessId, String triggerType) {
        this.id = jobId;
        this.expirationTime = Objects.requireNonNull(expirationTime);
        this.priority = Objects.requireNonNull(priority);
        this.processInstanceId = Objects.requireNonNull(processInstanceId);
        this.rootProcessInstanceId = rootProcessInstanceId;
        this.processId = processId;
        this.processVersion = processVersion;
        this.rootProcessId = rootProcessId;
        this.triggerType = Objects.requireNonNull(triggerType);
    }

    private ProcessInstanceJobDescription(String jobIdId, ExpirationTime expirationTime, Integer priority, String processInstanceId, String rootProcessInstanceId, String processId, String processVersion, String rootProcessId, String triggerType) {
        this.id = jobIdId;
        this.expirationTime = Objects.requireNonNull(expirationTime);
        this.priority = Objects.requireNonNull(priority);
        this.processInstanceId = Objects.requireNonNull(processInstanceId);
        this.rootProcessInstanceId = rootProcessInstanceId;
        this.processId = processId;
        this.processVersion = processVersion;
        this.rootProcessId = rootProcessId;
        this.triggerType = Objects.requireNonNull(triggerType);
    }

    public static ProcessInstanceJobDescription of(long timerId, ExpirationTime expirationTime, String processInstanceId, String processId, String processVersion) {
        return ProcessInstanceJobDescription.of(timerId, expirationTime, processInstanceId, null, processId, processVersion, null);
    }

    public static ProcessInstanceJobDescription of(String jobId, long timerId, ExpirationTime expirationTime, String processInstanceId, String rootProcessInstanceId, String processId, String processVersion, String rootProcessId) {
        return new ProcessInstanceJobDescription(jobId, timerId, expirationTime, DEFAULT_PRIORITY, processInstanceId, rootProcessInstanceId, processId, processVersion, rootProcessId, "timerTriggered");
    }

    public static ProcessInstanceJobDescription of(long timerId, ExpirationTime expirationTime, String processInstanceId, String rootProcessInstanceId, String processId, String processVersion, String rootProcessId) {
        return ProcessInstanceJobDescription.of(timerId, expirationTime, DEFAULT_PRIORITY, processInstanceId, rootProcessInstanceId, processId, processVersion, rootProcessId);
    }

    public static ProcessInstanceJobDescription of(long timerId, ExpirationTime expirationTime, Integer priority, String processInstanceId, String rootProcessInstanceId, String processId, String processVersion, String rootProcessId) {
        return new ProcessInstanceJobDescription(timerId, expirationTime, priority, processInstanceId, rootProcessInstanceId, processId, processVersion, rootProcessId, "timerTriggered");
    }

    public static ProcessInstanceJobDescription of(long timerId, String triggerType, ExpirationTime expirationTime, String processInstanceId, String processId, String processVersion) {
        return ProcessInstanceJobDescription.of(timerId, triggerType, expirationTime, processInstanceId, null, processId, processVersion, null);
    }

    public static ProcessInstanceJobDescription of(String jobId, String triggerType, ExpirationTime expirationTime, String processInstanceId, String processId, String processVersion) {
        return new ProcessInstanceJobDescription(jobId, expirationTime, DEFAULT_PRIORITY, processInstanceId, null, processId, processVersion, null, triggerType);
    }

    public static ProcessInstanceJobDescription of(long timerId, String triggerType, ExpirationTime expirationTime, String processInstanceId, String rootProcessInstanceId, String processId, String processVersion, String rootProcessId) {
        return ProcessInstanceJobDescription.of(timerId, triggerType, expirationTime, DEFAULT_PRIORITY, processInstanceId, rootProcessInstanceId, processId, processVersion, rootProcessId);
    }

    public static ProcessInstanceJobDescription of(String jobId, long timerId, String triggerType, ExpirationTime expirationTime, String processInstanceId, String rootProcessInstanceId, String processId, String processVersion, String rootProcessId) {
        return ProcessInstanceJobDescription.of(jobId, timerId, triggerType, expirationTime, DEFAULT_PRIORITY, processInstanceId, rootProcessInstanceId, processId, processVersion, rootProcessId);
    }

    public static ProcessInstanceJobDescription of(long timerId, String triggerType, ExpirationTime expirationTime, Integer priority, String processInstanceId, String rootProcessInstanceId, String processId, String processVersion, String rootProcessId) {
        return new ProcessInstanceJobDescription(timerId, expirationTime, priority, processInstanceId, rootProcessInstanceId, processId, processVersion, rootProcessId, triggerType);
    }

    public static ProcessInstanceJobDescription of(String jobId, long timerId, String triggerType, ExpirationTime expirationTime, Integer priority, String processInstanceId, String rootProcessInstanceId, String processId, String processVersion, String rootProcessId) {
        return new ProcessInstanceJobDescription(jobId, timerId, expirationTime, priority, processInstanceId, rootProcessInstanceId, processId, processVersion, rootProcessId, triggerType);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ExpirationTime expirationTime() {
        return this.expirationTime;
    }

    @Override
    public Integer priority() {
        return this.priority;
    }

    public String processInstanceId() {
        return this.processInstanceId;
    }

    public String rootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public String processId() {
        return this.processId;
    }

    public String processVersion() {
        return this.processVersion;
    }

    public String rootProcessId() {
        return this.rootProcessId;
    }

    public String triggerType() {
        return this.triggerType;
    }

    public String toString() {
        return "ProcessInstanceJobDescription{id='" + this.id + "', expirationTime=" + this.expirationTime + ", triggerType='" + this.triggerType + "', priority=" + this.priority + ", processInstanceId='" + this.processInstanceId + "', rootProcessInstanceId='" + this.rootProcessInstanceId + "', processId='" + this.processId + "', rootProcessId='" + this.rootProcessId + "'}";
    }
}

