/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.api.jobs;

import io.automatiko.engine.api.jobs.ExpirationTime;
import io.automatiko.engine.api.jobs.JobDescription;
import io.automatiko.engine.api.workflow.Process;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;

public class ProcessJobDescription
implements JobDescription {
    public static final Integer DEFAULT_PRIORITY = 5;
    private final String id;
    private final ExpirationTime expirationTime;
    private final Integer priority;
    private String processId;
    private String processVersion;
    private Process<?> process;

    private ProcessJobDescription(ExpirationTime expirationTime, Integer priority, String processId, String processVersion) {
        this.id = UUID.nameUUIDFromBytes(processId.getBytes(StandardCharsets.UTF_8)).toString();
        this.expirationTime = Objects.requireNonNull(expirationTime);
        this.priority = Objects.requireNonNull(priority);
        this.processId = Objects.requireNonNull(processId);
        this.processVersion = processVersion;
    }

    public ProcessJobDescription(ExpirationTime expirationTime, Integer priority, Process<?> process) {
        this.id = UUID.nameUUIDFromBytes(process.id().getBytes(StandardCharsets.UTF_8)).toString();
        this.expirationTime = Objects.requireNonNull(expirationTime);
        this.priority = Objects.requireNonNull(priority);
        this.process = Objects.requireNonNull(process);
        this.processId = Objects.requireNonNull(process.id());
        this.processVersion = process.version();
    }

    public static ProcessJobDescription of(ExpirationTime expirationTime, Process<?> process) {
        return new ProcessJobDescription(expirationTime, DEFAULT_PRIORITY, process);
    }

    public static ProcessJobDescription of(ExpirationTime expirationTime, String processId, String processVersion) {
        return ProcessJobDescription.of(expirationTime, DEFAULT_PRIORITY, processId, processVersion);
    }

    public static ProcessJobDescription of(ExpirationTime expirationTime, Integer priority, String processId, String processVersion) {
        return new ProcessJobDescription(expirationTime, priority, processId, processVersion);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ExpirationTime expirationTime() {
        return this.expirationTime;
    }

    @Override
    public Integer priority() {
        return this.priority;
    }

    public String processId() {
        return this.processId;
    }

    public String processVersion() {
        return this.processVersion;
    }

    public Process<?> process() {
        return this.process;
    }
}

