/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.api.uow;

import java.util.function.Consumer;

public interface WorkUnit<T> {
    public T data();

    public void perform();

    default public void abort() {
    }

    default public Integer priority() {
        return 100;
    }

    public static <S> WorkUnit<S> create(final S data, final Consumer<S> action) {
        return new WorkUnit<S>(){

            @Override
            public S data() {
                return data;
            }

            @Override
            public void perform() {
                action.accept(this.data());
            }
        };
    }

    public static <S> WorkUnit<S> create(final S data, final Consumer<S> action, final Consumer<S> compensation) {
        return new WorkUnit<S>(){

            @Override
            public S data() {
                return data;
            }

            @Override
            public void perform() {
                action.accept(this.data());
            }

            @Override
            public void abort() {
                compensation.accept(this.data());
            }
        };
    }
}

