/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.api.workflow;

import io.automatiko.engine.api.workflow.EventDescription;
import java.util.HashMap;
import java.util.Map;

public class AbstractEventDescription<T>
implements EventDescription<T> {
    protected String id;
    protected String event;
    protected String nodeId;
    protected String nodeName;
    protected String eventType;
    protected String nodeInstanceId;
    protected String processInstanceId;
    protected T dataType;
    protected Map<String, String> properties = new HashMap<String, String>();

    public AbstractEventDescription(String event, String nodeId, String nodeName, String eventType, String nodeInstanceId, String processInstanceId, T dataType) {
        this.id = nodeInstanceId != null ? nodeInstanceId : nodeId;
        this.event = event;
        this.nodeId = nodeId;
        this.nodeName = nodeName;
        this.eventType = eventType;
        this.nodeInstanceId = nodeInstanceId;
        this.processInstanceId = processInstanceId;
        this.dataType = dataType;
    }

    public AbstractEventDescription(String event, String nodeId, String nodeName, String eventType, String nodeInstanceId, String processInstanceId, T dataType, Map<String, String> properties) {
        this.id = nodeInstanceId != null ? nodeInstanceId : nodeId;
        this.event = event;
        this.nodeId = nodeId;
        this.nodeName = nodeName;
        this.eventType = eventType;
        this.nodeInstanceId = nodeInstanceId;
        this.processInstanceId = processInstanceId;
        this.dataType = dataType;
        this.properties = properties;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getEvent() {
        return this.event;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }

    @Override
    public String getNodeInstanceId() {
        return this.nodeInstanceId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public T getDataType() {
        return this.dataType;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "EventDesciption [event=" + this.event + ", nodeId=" + this.nodeId + ", nodeName=" + this.nodeName + ", eventType=" + this.eventType + ", nodeInstanceId=" + this.nodeInstanceId + ", processInstanceId=" + this.processInstanceId + ", dataType=" + this.dataType + ", properties=" + this.properties + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        result = 31 * result + (this.nodeName == null ? 0 : this.nodeName.hashCode());
        result = 31 * result + (this.eventType == null ? 0 : this.eventType.hashCode());
        result = 31 * result + (this.processInstanceId == null ? 0 : this.processInstanceId.hashCode());
        result = 31 * result + (this.nodeInstanceId == null ? 0 : this.nodeInstanceId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractEventDescription other = (AbstractEventDescription)obj;
        if (this.dataType == null ? other.dataType != null : !this.dataType.equals(other.dataType)) {
            return false;
        }
        if (this.event == null ? other.event != null : !this.event.equals(other.event)) {
            return false;
        }
        if (this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId)) {
            return false;
        }
        if (this.nodeName == null ? other.nodeName != null : !this.nodeName.equals(other.nodeName)) {
            return false;
        }
        if (this.eventType == null ? other.eventType != null : !this.eventType.equals(other.eventType)) {
            return false;
        }
        if (this.processInstanceId == null ? other.processInstanceId != null : !this.processInstanceId.equals(other.processInstanceId)) {
            return false;
        }
        return !(this.nodeInstanceId == null ? other.nodeInstanceId != null : !this.nodeInstanceId.equals(other.nodeInstanceId));
    }
}

