/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.api.workflow;

import io.automatiko.engine.api.workflow.ArchivedVariable;
import io.automatiko.engine.api.workflow.ExportedProcessInstance;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ArchivedProcessInstance {
    private final String id;
    private final String processId;
    private final ExportedProcessInstance<?> export;
    private List<ArchivedVariable> variables = new ArrayList<ArchivedVariable>();
    private List<ArchivedProcessInstance> subInstances = new ArrayList<ArchivedProcessInstance>();

    public ArchivedProcessInstance(String id, String processId, ExportedProcessInstance<?> export) {
        this.id = id;
        this.processId = processId;
        this.export = export;
    }

    public void addVariable(ArchivedVariable variable) {
        this.variables.add(variable);
    }

    public List<ArchivedVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<ArchivedVariable> variables) {
        this.variables = variables;
    }

    public void addSubInstance(ArchivedProcessInstance subInstance) {
        this.subInstances.add(subInstance);
    }

    public List<ArchivedProcessInstance> getSubInstances() {
        return this.subInstances;
    }

    public void setSubInstances(List<ArchivedProcessInstance> subInstances) {
        this.subInstances = subInstances;
    }

    public String getId() {
        return this.id;
    }

    public String getProcessId() {
        return this.processId;
    }

    public ExportedProcessInstance<?> getExport() {
        return this.export;
    }

    public void writeAsZip(OutputStream output) throws IOException {
        try (ZipOutputStream zipOut = new ZipOutputStream(output);){
            this.writeAsZip(output, zipOut, "");
        }
    }

    public void writeAsZip(OutputStream output, ZipOutputStream zipOut, String parent) throws IOException {
        ZipEntry zipEntry = new ZipEntry(parent + this.id);
        zipOut.putNextEntry(zipEntry);
        zipOut.write(this.export.data());
        for (ArchivedVariable variable : this.variables) {
            ZipEntry varZipEntry = new ZipEntry(parent + variable.getName());
            zipOut.putNextEntry(varZipEntry);
            zipOut.write(variable.data());
        }
        for (ArchivedProcessInstance subInstance : this.subInstances) {
            subInstance.writeAsZip(output, zipOut, parent + subInstance.getId() + File.separator);
        }
    }
}

