/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.api.workflow;

import io.automatiko.engine.api.workflow.ProcessInstance;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class InstanceMetadata {
    private String id;
    private String businessKey;
    private String description;
    private int state;
    private Set<String> tags;

    public InstanceMetadata() {
    }

    private InstanceMetadata(String id, String businessKey, String description, int state, Collection<String> tags) {
        this.id = id;
        this.businessKey = businessKey;
        this.description = description;
        this.state = state;
        this.tags = tags == null ? Collections.emptySet() : new HashSet<String>(tags);
    }

    public String getId() {
        return this.id;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getDescription() {
        return this.description;
    }

    public int getState() {
        return this.state;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public static InstanceMetadata of(ProcessInstance<?> instance) {
        return new InstanceMetadata(instance.id(), instance.businessKey(), instance.description(), instance.status(), instance.tags().values());
    }
}

