/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.api.workflow;

import io.automatiko.engine.api.workflow.ExportedProcessInstance;
import io.automatiko.engine.api.workflow.Process;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.api.workflow.ProcessInstanceNotFoundException;
import io.automatiko.engine.api.workflow.ProcessInstances;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface MutableProcessInstances<T>
extends ProcessInstances<T> {
    public static final String SEPARATOR = ":";

    public boolean exists(String var1);

    public void create(String var1, ProcessInstance<T> var2);

    public void update(String var1, ProcessInstance<T> var2);

    public void remove(String var1, ProcessInstance<T> var2);

    default public boolean isActive(ProcessInstance<T> instance) {
        if (instance.status() != 0 && instance.process().endOfInstanceStrategy().shouldInstanceBeUpdated()) {
            return true;
        }
        return instance.status() == 1 || instance.status() == 5;
    }

    default public boolean isPending(ProcessInstance<T> instance) {
        return instance.status() == 0;
    }

    default public String resolveId(String id) {
        if (id.contains(SEPARATOR)) {
            String[] parts = id.split(SEPARATOR);
            return Stream.of(parts).map(this::resolveId).collect(Collectors.joining(SEPARATOR));
        }
        try {
            return UUID.fromString(id).toString();
        }
        catch (IllegalArgumentException e) {
            return UUID.nameUUIDFromBytes(id.getBytes()).toString();
        }
    }

    default public String resolveId(String id, ProcessInstance<T> instance) {
        if (this.useCompositeIdForSubprocess() && instance.parentProcessInstanceId() != null) {
            return this.resolveId(instance.parentProcessInstanceId()) + SEPARATOR + this.resolveId(id);
        }
        return this.resolveId(id);
    }

    default public boolean useCompositeIdForSubprocess() {
        return true;
    }

    default public int calculatePage(int page, int size) {
        if (page <= 1) {
            return 0;
        }
        return (page - 1) * size;
    }

    default public ExportedProcessInstance exportInstance(String id) {
        return this.exportInstance(this.findById(id).orElseThrow(() -> new ProcessInstanceNotFoundException(id)), false);
    }

    default public ExportedProcessInstance exportInstance(String id, boolean abort) {
        return this.exportInstance(this.findById(id).orElseThrow(() -> new ProcessInstanceNotFoundException(id)), abort);
    }

    public ExportedProcessInstance exportInstance(ProcessInstance<?> var1, boolean var2);

    public ProcessInstance<T> importInstance(ExportedProcessInstance var1, Process<T> var2);
}

