/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.api.workflow;

import io.automatiko.engine.api.workflow.ProcessError;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ProcessErrors {
    private List<ProcessError> errors = new ArrayList<ProcessError>();

    public ProcessErrors(List<ProcessError> errors) {
        this.errors = errors;
    }

    public List<ProcessError> errors() {
        return this.errors;
    }

    public void retrigger(String nodeId) {
        this.errors.stream().filter(e -> e.failedNodeId().equals(nodeId)).findFirst().ifPresent(e -> e.retrigger());
    }

    public void skip(String nodeId) {
        this.errors.stream().filter(e -> e.failedNodeId().equals(nodeId)).findFirst().ifPresent(e -> e.skip());
    }

    public void retrigger() {
        for (ProcessError error : this.errors) {
            try {
                error.retrigger();
            }
            catch (Exception exception) {}
        }
    }

    public void skip() {
        for (ProcessError error : this.errors) {
            try {
                error.skip();
            }
            catch (Exception exception) {}
        }
    }

    public String failedNodeIds() {
        return this.errors.stream().map(e -> e.failedNodeId()).collect(Collectors.joining(","));
    }

    public String errorMessages() {
        return this.errors.stream().map(e -> e.errorMessage()).collect(Collectors.joining(","));
    }
}

