/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.api.workflow.files;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface File<T> {
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final String ENTRIES_ATTR = "entries";

    public String name();

    default public String type() {
        return File.discoverType(this.name());
    }

    public T content();

    public Map<String, String> attributes();

    public String url();

    default public List<String> entries() {
        String entries;
        if (this.attributes() != null && (entries = this.attributes().get(ENTRIES_ATTR)) != null) {
            return Arrays.asList(entries.split(","));
        }
        return Collections.emptyList();
    }

    public static String discoverType(String name) {
        try {
            String contentType = Files.probeContentType(Paths.get(name, new String[0]));
            if (contentType == null) {
                contentType = DEFAULT_CONTENT_TYPE;
            }
            return contentType;
        }
        catch (IOException e) {
            return DEFAULT_CONTENT_TYPE;
        }
    }
}

