/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.event.impl;

import io.automatiko.engine.api.event.DataEvent;
import io.automatiko.engine.api.event.EventPublisher;
import io.automatiko.engine.services.event.ProcessInstanceDataEvent;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class CountDownProcessInstanceEventPublisher
implements EventPublisher {
    private static CountDownLatch latch;

    public void publish(DataEvent<?> event) {
        if (event instanceof ProcessInstanceDataEvent) {
            latch.countDown();
        }
    }

    public void publish(Collection<DataEvent<?>> events) {
        events.forEach(e -> this.publish((DataEvent<?>)e));
    }

    public void reset(int count) {
        latch = new CountDownLatch(count);
    }

    public void waitTillCompletion(long timeout) throws InterruptedException {
        this.waitTillCompletion(timeout, TimeUnit.SECONDS);
    }

    public void waitTillCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        boolean isZero = latch.await(timeout, unit);
        if (!isZero) {
            throw new RuntimeException("Exceeded time waiting on completion");
        }
    }
}

