/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.event.impl;

import io.automatiko.engine.api.Addons;
import io.automatiko.engine.api.event.DataEvent;
import io.automatiko.engine.api.event.EventBatch;
import io.automatiko.engine.api.event.process.ProcessCompletedEvent;
import io.automatiko.engine.api.event.process.ProcessEvent;
import io.automatiko.engine.api.event.process.ProcessNodeEvent;
import io.automatiko.engine.api.event.process.ProcessNodeLeftEvent;
import io.automatiko.engine.api.event.process.ProcessNodeTriggeredEvent;
import io.automatiko.engine.api.event.process.ProcessVariableChangedEvent;
import io.automatiko.engine.api.event.process.ProcessWorkItemTransitionEvent;
import io.automatiko.engine.api.runtime.process.HumanTaskWorkItem;
import io.automatiko.engine.api.runtime.process.NodeInstance;
import io.automatiko.engine.api.runtime.process.WorkItem;
import io.automatiko.engine.api.runtime.process.WorkflowProcessInstance;
import io.automatiko.engine.api.uow.WorkUnit;
import io.automatiko.engine.api.workflow.ExecutionsErrorInfo;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.services.event.ProcessInstanceDataEvent;
import io.automatiko.engine.services.event.UserTaskInstanceDataEvent;
import io.automatiko.engine.services.event.VariableInstanceDataEvent;
import io.automatiko.engine.services.event.impl.MilestoneEventBody;
import io.automatiko.engine.services.event.impl.NodeInstanceEventBody;
import io.automatiko.engine.services.event.impl.ProcessErrorEventBody;
import io.automatiko.engine.services.event.impl.ProcessInstanceEventBody;
import io.automatiko.engine.services.event.impl.UserTaskInstanceEventBody;
import io.automatiko.engine.services.event.impl.VariableInstanceEventBody;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ProcessInstanceEventBatch
implements EventBatch {
    public static final String TRACKED = "tracked";
    private final String service;
    private Addons addons;
    private List<ProcessEvent> rawEvents = new ArrayList<ProcessEvent>();

    public ProcessInstanceEventBatch(String service, Addons addons) {
        this.service = service;
        this.addons = addons;
    }

    public void append(Object rawEvent) {
        if (rawEvent instanceof ProcessEvent) {
            this.rawEvents.add((ProcessEvent)rawEvent);
        } else if (rawEvent instanceof WorkUnit) {
            this.append(((WorkUnit)rawEvent).data());
        } else if (rawEvent instanceof Collection) {
            for (Object event : (Collection)rawEvent) {
                this.append(event);
            }
        }
    }

    public Collection<DataEvent<?>> events() {
        LinkedHashMap<String, ProcessInstanceEventBody> processInstances = new LinkedHashMap<String, ProcessInstanceEventBody>();
        LinkedHashMap<String, UserTaskInstanceEventBody> userTaskInstances = new LinkedHashMap<String, UserTaskInstanceEventBody>();
        LinkedHashSet<VariableInstanceEventBody> variables = new LinkedHashSet<VariableInstanceEventBody>();
        for (ProcessEvent event : this.rawEvents) {
            ProcessInstanceEventBody body = processInstances.computeIfAbsent(event.getProcessInstance().getId(), key -> this.create(event));
            if (event instanceof ProcessNodeTriggeredEvent) {
                this.handleProcessNodeTriggeredEvent((ProcessNodeTriggeredEvent)event, body);
                continue;
            }
            if (event instanceof ProcessNodeLeftEvent) {
                this.handleProcessNodeLeftEvent((ProcessNodeLeftEvent)event, body);
                continue;
            }
            if (event instanceof ProcessCompletedEvent) {
                this.handleProcessCompletedEvent((ProcessCompletedEvent)event, body);
                continue;
            }
            if (event instanceof ProcessWorkItemTransitionEvent) {
                this.handleProcessWorkItemTransitionEvent((ProcessWorkItemTransitionEvent)event, userTaskInstances);
                continue;
            }
            if (!(event instanceof ProcessVariableChangedEvent)) continue;
            this.handleProcessVariableChangedEvent((ProcessVariableChangedEvent)event, variables);
        }
        ArrayList processedEvents = new ArrayList();
        processInstances.values().stream().map(pi -> new ProcessInstanceDataEvent(this.extractRuntimeSource(pi.metaData()), this.addons.toString(), pi.metaData(), (ProcessInstanceEventBody)pi)).forEach(processedEvents::add);
        userTaskInstances.values().stream().map(pi -> new UserTaskInstanceDataEvent(this.extractRuntimeSource(pi.metaData()), this.addons.toString(), pi.metaData(), (UserTaskInstanceEventBody)pi)).forEach(processedEvents::add);
        variables.stream().map(pi -> new VariableInstanceDataEvent(this.extractRuntimeSource(pi.metaData()), this.addons.toString(), pi.metaData(), (VariableInstanceEventBody)pi)).forEach(processedEvents::add);
        return processedEvents;
    }

    protected void handleProcessCompletedEvent(ProcessCompletedEvent event, ProcessInstanceEventBody body) {
        body.update().endDate(((WorkflowProcessInstance)event.getProcessInstance()).getEndDate()).state(event.getProcessInstance().getState());
    }

    protected void handleProcessNodeTriggeredEvent(ProcessNodeTriggeredEvent event, ProcessInstanceEventBody body) {
        NodeInstanceEventBody nodeInstanceBody = this.create((ProcessNodeEvent)event);
        if (!body.getNodeInstances().contains(nodeInstanceBody)) {
            body.update().nodeInstance(nodeInstanceBody);
        }
    }

    protected void handleProcessNodeLeftEvent(ProcessNodeLeftEvent event, ProcessInstanceEventBody body) {
        NodeInstanceEventBody nodeInstanceBody = this.create((ProcessNodeEvent)event);
        body.getNodeInstances().remove(nodeInstanceBody);
        body.update().nodeInstance(nodeInstanceBody);
    }

    protected void handleProcessWorkItemTransitionEvent(ProcessWorkItemTransitionEvent workItemTransitionEvent, Map<String, UserTaskInstanceEventBody> userTaskInstances) {
        WorkItem workItem = workItemTransitionEvent.getWorkItem();
        if (workItem instanceof HumanTaskWorkItem && workItemTransitionEvent.isTransitioned()) {
            userTaskInstances.putIfAbsent(workItem.getId(), this.createUserTask(workItemTransitionEvent));
        }
    }

    protected void handleProcessVariableChangedEvent(ProcessVariableChangedEvent variableChangedEvent, Set<VariableInstanceEventBody> variables) {
        if (variableChangedEvent.hasTag(TRACKED)) {
            variables.add(this.create(variableChangedEvent));
        }
    }

    protected UserTaskInstanceEventBody createUserTask(ProcessWorkItemTransitionEvent workItemTransitionEvent) {
        WorkflowProcessInstance pi = (WorkflowProcessInstance)workItemTransitionEvent.getProcessInstance();
        HumanTaskWorkItem workItem = (HumanTaskWorkItem)workItemTransitionEvent.getWorkItem();
        Object parentProcessInstanceId = pi.getParentProcessInstanceId();
        parentProcessInstanceId = parentProcessInstanceId != null && !((String)parentProcessInstanceId).isEmpty() ? (String)parentProcessInstanceId + ":" : "";
        String version = this.version(pi.getProcess().getVersion());
        String encoded = Base64.getEncoder().encodeToString((pi.getProcessId() + version + "|" + (String)parentProcessInstanceId + pi.getId() + "|" + workItem.getId() + "|").getBytes(StandardCharsets.UTF_8));
        String link = "/management/tasks/link/" + encoded;
        return UserTaskInstanceEventBody.create().id(workItem.getId()).state(workItem.getPhaseStatus()).taskName(workItem.getTaskName()).taskDescription(workItem.getTaskDescription()).taskPriority(workItem.getTaskPriority()).referenceName(workItem.getReferenceName()).referenceId(workItem.getReferenceId()).formLink(link).actualOwner(workItem.getActualOwner()).startDate(workItem.getStartDate()).completeDate(workItem.getCompleteDate()).adminGroups(workItem.getAdminGroups()).adminUsers(workItem.getAdminUsers()).excludedUsers(workItem.getExcludedUsers()).potentialGroups(workItem.getPotentialGroups()).potentialUsers(workItem.getPotentialUsers()).processInstanceId(pi.getId()).rootProcessInstanceId(pi.getRootProcessInstanceId()).processId(pi.getProcessId()).rootProcessId(pi.getRootProcessId()).inputs(workItem.getParameters()).outputs(workItem.getResults()).instance(workItem).build();
    }

    protected ProcessInstanceEventBody create(ProcessEvent event) {
        ProcessInstance instance;
        Collection tags;
        String securityRoles;
        WorkflowProcessInstance pi = (WorkflowProcessInstance)event.getProcessInstance();
        ProcessInstanceEventBody.Builder eventBuilder = ProcessInstanceEventBody.create().id(pi.getId()).parentInstanceId(pi.getParentProcessInstanceId()).rootInstanceId(pi.getRootProcessInstanceId()).processId(pi.getProcessId()).rootProcessId(pi.getRootProcessId()).processName(pi.getProcessName()).startDate(pi.getStartDate()).endDate(pi.getEndDate()).state(pi.getState()).businessKey(pi.getCorrelationKey()).variables(pi.getPublicVariables()).milestones(this.createMilestones(pi));
        if (pi.getState() == 5) {
            for (ExecutionsErrorInfo error : pi.errors()) {
                eventBuilder.error(ProcessErrorEventBody.create().nodeDefinitionId(error.getFailedNodeId()).errorMessage(error.getErrorMessage()).build());
            }
        }
        if ((securityRoles = (String)pi.getProcess().getMetaData().get("securityRoles")) != null) {
            eventBuilder.roles(securityRoles.split(","));
        }
        if ((tags = pi.getTags()) != null) {
            eventBuilder.tags((String[])tags.stream().map(t -> t.getValue()).toArray(String[]::new));
        }
        if ((instance = (ProcessInstance)pi.getMetaData("AutomatikProcessInstance")) != null) {
            Set visibleTo = instance.process().accessPolicy().visibleTo(instance);
            if (visibleTo != null) {
                eventBuilder.visibleTo((String[])visibleTo.toArray(String[]::new));
            }
            eventBuilder.instance(instance);
        }
        return eventBuilder.build();
    }

    protected Set<MilestoneEventBody> createMilestones(WorkflowProcessInstance pi) {
        if (pi.milestones() == null) {
            return null;
        }
        return pi.milestones().stream().map(m -> MilestoneEventBody.create().id(m.getId()).name(m.getName()).status(m.getStatus().name()).build()).collect(Collectors.toSet());
    }

    protected NodeInstanceEventBody create(ProcessNodeEvent event) {
        NodeInstance ni = event.getNodeInstance();
        return NodeInstanceEventBody.create().id(ni.getId()).nodeId(String.valueOf(ni.getNodeId())).nodeDefinitionId(ni.getNodeDefinitionId()).nodeName(ni.getNodeName()).nodeType(ni.getNode().getClass().getSimpleName()).triggerTime(ni.getTriggerTime()).leaveTime(ni.getLeaveTime()).build();
    }

    protected VariableInstanceEventBody create(ProcessVariableChangedEvent event) {
        VariableInstanceEventBody.Builder eventBuilder = VariableInstanceEventBody.create().changeDate(event.getEventDate()).processId(event.getProcessInstance().getProcessId()).processInstanceId(event.getProcessInstance().getId()).rootProcessId(event.getProcessInstance().getRootProcessId()).rootProcessInstanceId(event.getProcessInstance().getRootProcessInstanceId()).variableName(event.getVariableId()).variableValue(event.getNewValue()).variablePreviousValue(event.getOldValue());
        if (event.getNodeInstance() != null) {
            eventBuilder.changedByNodeId(event.getNodeInstance().getNodeDefinitionId()).changedByNodeName(event.getNodeInstance().getNodeName()).changedByNodeType(event.getNodeInstance().getNode().getClass().getSimpleName());
        }
        return eventBuilder.build();
    }

    protected String extractRuntimeSource(Map<String, String> metadata) {
        String processId = metadata.get("kogito.processinstance.processId");
        if (processId == null) {
            return null;
        }
        return this.service + "/" + (processId.contains(".") ? processId.substring(processId.lastIndexOf(46) + 1) : processId);
    }

    protected String version(String version) {
        if (version != null && !version.trim().isEmpty()) {
            return "_" + version.replaceAll("\\.", "_");
        }
        return "";
    }
}

