/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.event.impl;

import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.services.event.impl.MilestoneEventBody;
import io.automatiko.engine.services.event.impl.NodeInstanceEventBody;
import io.automatiko.engine.services.event.impl.ProcessErrorEventBody;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProcessInstanceEventBody {
    public static final String ID_META_DATA = "kogito.processinstance.id";
    public static final String PARENT_ID_META_DATA = "kogito.processinstance.parentInstanceId";
    public static final String ROOT_ID_META_DATA = "kogito.processinstance.rootInstanceId";
    public static final String PROCESS_ID_META_DATA = "kogito.processinstance.processId";
    public static final String ROOT_PROCESS_ID_META_DATA = "kogito.processinstance.rootProcessId";
    public static final String STATE_META_DATA = "kogito.processinstance.state";
    private String id;
    private String parentInstanceId;
    private String rootInstanceId;
    private String processId;
    private String rootProcessId;
    private String processName;
    private Date startDate;
    private Date endDate;
    private Integer state;
    private String businessKey;
    private Set<NodeInstanceEventBody> nodeInstances = new LinkedHashSet<NodeInstanceEventBody>();
    private Map<String, Object> variables;
    private List<ProcessErrorEventBody> errors = new ArrayList<ProcessErrorEventBody>();
    private List<String> roles;
    private List<String> visibleTo;
    private List<String> tags;
    private Set<MilestoneEventBody> milestones = Collections.emptySet();
    private transient ProcessInstance<?> instance;

    private ProcessInstanceEventBody() {
    }

    public String getId() {
        return this.id;
    }

    public String getParentInstanceId() {
        return this.parentInstanceId;
    }

    public String getRootInstanceId() {
        return this.rootInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getRootProcessId() {
        return this.rootProcessId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Integer getState() {
        return this.state;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public List<ProcessErrorEventBody> getErrors() {
        return this.errors;
    }

    public Set<NodeInstanceEventBody> getNodeInstances() {
        return this.nodeInstances;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<String> getVisibleTo() {
        return this.visibleTo;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Set<MilestoneEventBody> getMilestones() {
        return this.milestones;
    }

    public ProcessInstance<?> sourceInstance() {
        return this.instance;
    }

    public Builder update() {
        return new Builder(this);
    }

    public Map<String, String> metaData() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(ID_META_DATA, this.id);
        metadata.put(PARENT_ID_META_DATA, this.parentInstanceId);
        metadata.put(ROOT_ID_META_DATA, this.rootInstanceId);
        metadata.put(PROCESS_ID_META_DATA, this.processId);
        metadata.put(ROOT_PROCESS_ID_META_DATA, this.rootProcessId);
        metadata.put(STATE_META_DATA, String.valueOf(this.state));
        return metadata;
    }

    public String toString() {
        return "ProcessInstanceEventBody [id=" + this.id + ", parentInstanceId=" + this.parentInstanceId + ", rootInstanceId=" + this.rootInstanceId + ", processId=" + this.processId + ", rootProcessId=" + this.rootProcessId + ", processName=" + this.processName + ", startDate=" + String.valueOf(this.startDate) + ", endDate=" + String.valueOf(this.endDate) + ", state=" + this.state + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessInstanceEventBody other = (ProcessInstanceEventBody)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public static Builder create() {
        return new Builder(new ProcessInstanceEventBody());
    }

    static class Builder {
        private ProcessInstanceEventBody instance;

        public Builder(ProcessInstanceEventBody instance) {
            this.instance = instance;
        }

        public Builder id(String id) {
            this.instance.id = id;
            return this;
        }

        public Builder parentInstanceId(String parentInstanceId) {
            this.instance.parentInstanceId = parentInstanceId;
            return this;
        }

        public Builder rootInstanceId(String rootInstanceId) {
            this.instance.rootInstanceId = rootInstanceId;
            return this;
        }

        public Builder processId(String processId) {
            this.instance.processId = processId;
            return this;
        }

        public Builder rootProcessId(String rootProcessId) {
            this.instance.rootProcessId = rootProcessId;
            return this;
        }

        public Builder processName(String processName) {
            this.instance.processName = processName;
            return this;
        }

        public Builder startDate(Date date) {
            this.instance.startDate = date;
            return this;
        }

        public Builder endDate(Date date) {
            this.instance.endDate = date;
            return this;
        }

        public Builder state(Integer state) {
            this.instance.state = state;
            return this;
        }

        public Builder businessKey(String businessKey) {
            this.instance.businessKey = businessKey;
            return this;
        }

        public Builder nodeInstance(NodeInstanceEventBody nodeInstance) {
            this.instance.nodeInstances.add(nodeInstance);
            return this;
        }

        public Builder variables(Map<String, Object> variables) {
            this.instance.variables = variables;
            return this;
        }

        public Builder error(ProcessErrorEventBody error) {
            this.instance.errors.add(error);
            return this;
        }

        public Builder roles(String ... roles) {
            this.instance.roles = Arrays.asList(roles);
            return this;
        }

        public Builder visibleTo(String ... visibleTo) {
            this.instance.visibleTo = Arrays.asList(visibleTo);
            return this;
        }

        public Builder tags(String ... tags) {
            this.instance.tags = Arrays.asList(tags);
            return this;
        }

        public Builder milestones(Set<MilestoneEventBody> milestones) {
            this.instance.milestones = milestones;
            return this;
        }

        public Builder instance(ProcessInstance<?> pinstance) {
            this.instance.instance = pinstance;
            return this;
        }

        public ProcessInstanceEventBody build() {
            return this.instance;
        }
    }
}

